/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.creation;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.IWrapperInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ILiveCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.CreationAttributeDescription;
import org.eclipse.wb.internal.core.xml.model.description.CreationDescription;
import org.eclipse.wb.internal.core.xml.model.utils.NamespacesHelper;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public class ElementCreationSupport
extends CreationSupport
implements ILiveCreationSupport {
    private DocumentElement m_element;
    private String m_creationId;
    private boolean m_addAttributes;

    public ElementCreationSupport(DocumentElement element) {
        this.m_element = element;
    }

    public ElementCreationSupport() {
        this((String)null);
    }

    public ElementCreationSupport(String creationId) {
        this(creationId, true);
    }

    public ElementCreationSupport(String creationId, boolean addAttributes) {
        this.m_creationId = creationId;
        this.m_addAttributes = addAttributes;
    }

    public String toString() {
        if (this.m_element == null) {
            return String.valueOf(this.m_creationId) + " " + this.m_addAttributes;
        }
        return ElementCreationSupport.getElementString(this.m_element);
    }

    public static String getElementString(DocumentElement element) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        element.writeShort(printWriter);
        String result = stringWriter.toString();
        result = result.replaceAll("\\s*xmlns:*\\w*=\"[^\"]*\"", "");
        return result;
    }

    public DocumentElement getElement() {
        return this.m_element;
    }

    public String getTitle() {
        return this.m_element.getTag();
    }

    public void setObject(XmlObjectInfo object) throws Exception {
        super.setObject(object);
        CreationDescription creation = this.m_object.getDescription().getCreation(this.m_creationId);
        if (creation != null) {
            for (Map.Entry<String, String> entry : creation.getParameters().entrySet()) {
                XmlObjectUtils.setParameter(this.m_object, entry.getKey(), entry.getValue());
            }
        }
    }

    public void delete() throws Exception {
        List children = (List)ImmutableList.copyOf((Collection)this.m_object.getChildren());
        for (ObjectInfo child : children) {
            child.delete();
        }
        if (this.m_object.isRoot()) {
            return;
        }
        DocumentElement elementToRemove = this.getElementToRemove();
        elementToRemove.remove();
        this.m_object.getParent().removeChild((ObjectInfo)this.m_object);
    }

    private DocumentElement getElementToRemove() {
        if (this.m_object instanceof IWrapperInfo) {
            return this.m_element;
        }
        XmlObjectInfo parent = this.m_object.getParentXML();
        return XmlObjectUtils.getElementInParent(parent, this.m_element);
    }

    public void addElement(DocumentElement parent, int index) throws Exception {
        String content;
        ComponentDescription description = this.m_object.getDescription();
        Class<?> componentClass = description.getComponentClass();
        CreationDescription creation = description.getCreation(this.m_creationId);
        Assert.isNotNull2((Object)creation, (String)"No creation: {0} {1}", (Object[])new Object[]{componentClass, this.m_creationId});
        this.m_element = new DocumentElement();
        String tag = XmlObjectUtils.getTagForClass(this.m_object, componentClass);
        this.m_element.setTag(tag);
        parent.addChild(this.m_element, index);
        if (this.m_addAttributes) {
            for (CreationAttributeDescription attribute : creation.getAttributes()) {
                new AddAttributeHelper(this.m_element).addAttribute(attribute);
            }
        }
        if (this.m_addAttributes && (content = creation.getContent()) != null) {
            this.m_element.setText(content, false);
        }
    }

    public IClipboardCreationSupport getClipboard() {
        return new IClipboardCreationSupport(){
            private static final long serialVersionUID = 0L;

            public CreationSupport create(XmlObjectInfo rootObject) throws Exception {
                return new ElementCreationSupport(null, false);
            }
        };
    }

    public CreationSupport getLiveComponentCreation() {
        return new ElementCreationSupport(this.m_creationId, this.m_addAttributes);
    }

    private static class AddAttributeHelper
    extends NamespacesHelper {
        private final DocumentElement m_element;

        public AddAttributeHelper(DocumentElement element) {
            super(element.getRoot());
            this.m_element = element;
        }

        void addAttribute(CreationAttributeDescription attribute) {
            String prefix = this.getNamespacePrefix(attribute);
            this.m_element.setAttribute(String.valueOf(prefix) + attribute.getName(), attribute.getValue());
        }

        private String getNamespacePrefix(CreationAttributeDescription attribute) {
            String namespace = attribute.getNamespace();
            if (StringUtils.isEmpty((String)namespace)) {
                return "";
            }
            return String.valueOf(this.ensureName(namespace, "a")) + ":";
        }
    }
}

