/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wb.core.model.ObjectInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectsTreeContentProvider
implements ITreeContentProvider {
    private final Predicate<ObjectInfo> m_predicate;

    public ObjectsTreeContentProvider(Predicate<ObjectInfo> predicate) {
        this.m_predicate = predicate;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        List<ObjectInfo> children = ((ObjectInfo)parentElement).getChildren();
        Iterable filtered = Iterables.filter(children, this.m_predicate);
        return Iterables.toArray((Iterable)filtered, ObjectInfo.class);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length != 0;
    }

    public Object getParent(Object element) {
        return ((ObjectInfo)element).getParent();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

