/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor.style;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAddProperties;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.EmptyXmlProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.xml.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.xml.model.property.XmlProperty;
import org.eclipse.wb.internal.core.xml.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.xwt.model.property.editor.style.IStyleClassResolver;
import org.eclipse.wb.internal.xwt.model.property.editor.style.SubStyleProperty;
import org.eclipse.wb.internal.xwt.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.xwt.model.property.editor.style.XwtStyleClassResolver;
import org.eclipse.wb.internal.xwt.model.property.editor.style.impl.BooleanStylePropertyImpl;
import org.eclipse.wb.internal.xwt.model.property.editor.style.impl.MacroStylePropertyImpl;
import org.eclipse.wb.internal.xwt.model.property.editor.style.impl.SelectionStylePropertyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylePropertyEditor
extends TextDisplayPropertyEditor
implements IConfigurablePropertyObject,
IComplexPropertyEditor {
    private IStyleClassResolver m_classResolver;
    private String m_className;
    private Class<?> m_class;
    private final List<SubStylePropertyImpl> m_macroProperties = Lists.newArrayList();
    private final List<SubStylePropertyImpl> m_otherProperties = Lists.newArrayList();
    private SubStylePropertyImpl[] m_properties;

    protected String getText(Property property) throws Exception {
        return "[" + this.getSource(property, false, ", ") + "]";
    }

    long getStyle(Property property) throws Exception {
        Number value = (Number)property.getValue();
        return value != null ? value.longValue() : 0L;
    }

    void setStyleValue(Property property, long newValue) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        String source = this.getSource((Property)StylePropertyEditor.getPropertyForValue(genericProperty.getObject(), newValue));
        genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
    }

    private static XmlProperty getPropertyForValue(XmlObjectInfo object, final Object value) {
        return new EmptyXmlProperty(object){

            public Object getValue() throws Exception {
                return value;
            }
        };
    }

    private String getSource(Property property) throws Exception {
        return this.getSource(property, true, " | ");
    }

    private String getSource(Property property, boolean addClassAndDefault, String separator) throws Exception {
        String sFlag;
        StringBuffer source = new StringBuffer();
        long macroFlag = 0L;
        for (SubStylePropertyImpl subProperty : this.m_macroProperties) {
            sFlag = subProperty.getFlagValue(property);
            if (sFlag == null) continue;
            if (addClassAndDefault) {
                this.addClassPrefix(property, source);
            }
            source.append(sFlag);
            macroFlag = subProperty.getFlag(sFlag);
            break;
        }
        for (SubStylePropertyImpl subProperty : this.m_otherProperties) {
            sFlag = subProperty.getFlagValue(property);
            if (sFlag == null || macroFlag != 0L && (macroFlag & subProperty.getFlag(sFlag)) != 0L) continue;
            if (source.length() != 0) {
                source.append(separator);
            }
            if (addClassAndDefault) {
                this.addClassPrefix(property, source);
            }
            source.append(sFlag);
        }
        if (addClassAndDefault && source.length() == 0) {
            return null;
        }
        return source.toString();
    }

    private void addClassPrefix(Property property, StringBuffer source) {
        String prefix = this.m_classResolver.resolve(property, this.m_className);
        if (!StringUtils.isEmpty((String)prefix)) {
            source.append(prefix);
        }
    }

    public void setClassResolver(IStyleClassResolver classResolver) {
        this.m_classResolver = classResolver;
    }

    public void configure(EditorContext context, Map<String, Object> parameters) throws Exception {
        this.m_className = (String)parameters.get("class");
        this.m_class = context.getClassLoader().loadClass(this.m_className);
        List properties = Lists.newArrayList();
        this.configureSet(properties, context, parameters);
        this.configureMacro(properties, context, parameters);
        this.configureSelect(properties, context, parameters);
        this.m_properties = properties.toArray(new SubStylePropertyImpl[properties.size()]);
    }

    private void configureSet(List<SubStylePropertyImpl> properties, EditorContext context, Map<String, Object> parameters) throws Exception {
        if (parameters.containsKey("set")) {
            String[] setters = StringUtils.split((String)((String)parameters.get("set")));
            int i = 0;
            while (i < setters.length) {
                String[] names = StringUtils.split((String)setters[i], (char)':');
                String flagName = names[0];
                Field field = StylePropertyEditor.getField(context, this.m_class, flagName);
                if (field != null) {
                    long flag = field.getLong(null);
                    BooleanStylePropertyImpl property = names.length == 2 ? new BooleanStylePropertyImpl(this, names[1], flagName, flag) : new BooleanStylePropertyImpl(this, flagName.toLowerCase(), flagName, flag);
                    properties.add(property);
                    this.m_otherProperties.add(property);
                }
                ++i;
            }
        }
    }

    private void configureMacro(List<SubStylePropertyImpl> properties, EditorContext context, Map<String, Object> parameters) throws Exception {
        String key;
        int macroIndex = 0;
        while (parameters.containsKey(key = "macro" + Integer.toString(macroIndex++))) {
            String[] values = StringUtils.split((String)((String)parameters.get(key)));
            String title = values[0];
            int flagCount = 0;
            String[] flagValues = new String[values.length - 1];
            int i = 0;
            while (i < flagValues.length) {
                String flag = values[i + 1];
                if (StylePropertyEditor.getField(context, this.m_class, flag) != null) {
                    flagValues[flagCount++] = flag;
                }
                ++i;
            }
            long[] flags = new long[flagCount];
            String[] sFlags = new String[flagCount + 1];
            sFlags[flagCount] = "";
            int i2 = 0;
            while (i2 < flagCount) {
                String flag = flagValues[i2];
                flags[i2] = this.m_class.getField(flag).getLong(null);
                sFlags[i2] = flag;
                ++i2;
            }
            MacroStylePropertyImpl property = new MacroStylePropertyImpl(this, title, flags, sFlags);
            properties.add(property);
            this.m_macroProperties.add(property);
        }
    }

    private void configureSelect(List<SubStylePropertyImpl> properties, EditorContext context, Map<String, Object> parameters) throws Exception {
        String key;
        int selectIndex = 0;
        while (parameters.containsKey(key = "select" + Integer.toString(selectIndex++))) {
            String[] values = StringUtils.split((String)((String)parameters.get(key)));
            String title = values[0];
            String defaultString = values[1];
            long defaultFlag = StringUtils.isNumeric((String)defaultString) ? Long.parseLong(defaultString) : this.m_class.getField(defaultString).getLong(null);
            int flagCount = 0;
            String[] flagValues = new String[values.length - 2];
            int i = 0;
            while (i < flagValues.length) {
                String flag = values[i + 2];
                if (StringUtils.isNumeric((String)flag) || StylePropertyEditor.getField(context, this.m_class, flag) != null) {
                    flagValues[flagCount++] = flag;
                }
                ++i;
            }
            long[] flags = new long[flagCount];
            String[] sFlags = new String[flagCount];
            int i2 = 0;
            while (i2 < flagCount) {
                String flag = flagValues[i2];
                flags[i2] = StringUtils.isNumeric((String)flag) ? Long.parseLong(flag) : this.m_class.getField(flag).getLong(null);
                sFlags[i2] = flag;
                ++i2;
            }
            SelectionStylePropertyImpl property = new SelectionStylePropertyImpl(this, title, flags, sFlags, defaultFlag);
            properties.add(property);
            this.m_otherProperties.add(property);
        }
    }

    private static Field getField(EditorContext context, Class<?> baseClass, String name) {
        try {
            return baseClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            context.addWarning(new EditorWarning("StylePropertyEditor: can not find field " + baseClass.getName() + "." + name, (Throwable)e));
            return null;
        }
    }

    public Property[] getProperties(Property mainProperty) throws Exception {
        GenericProperty genericProperty = (GenericProperty)mainProperty;
        XmlObjectInfo xmlObject = genericProperty.getObject();
        Property[] properties = (Property[])xmlObject.getArbitraryValue((Object)this);
        if (properties == null) {
            int length = this.m_properties.length;
            properties = new Property[length];
            int i = 0;
            while (i < length) {
                properties[i] = new SubStyleProperty(mainProperty, this.m_properties[i]);
                ++i;
            }
            xmlObject.putArbitraryValue((Object)this, (Object)properties);
        }
        return properties;
    }

    public void contributeActions(Property mainProperty, IMenuManager manager, String implementTitle, boolean isCascade) throws Exception {
        MenuManager implementMenuManager = new MenuManager(implementTitle);
        if (isCascade) {
            SubStylePropertyImpl property;
            SubStylePropertyImpl[] subStylePropertyImplArray = this.m_properties;
            int n = this.m_properties.length;
            int n2 = 0;
            while (n2 < n) {
                property = subStylePropertyImplArray[n2];
                if (property instanceof BooleanStylePropertyImpl) {
                    property.contributeActions(mainProperty, (IMenuManager)implementMenuManager);
                }
                ++n2;
            }
            implementMenuManager.add((IContributionItem)new Separator());
            subStylePropertyImplArray = this.m_properties;
            n = this.m_properties.length;
            n2 = 0;
            while (n2 < n) {
                property = subStylePropertyImplArray[n2];
                if (!(property instanceof BooleanStylePropertyImpl)) {
                    MenuManager subMenu = new MenuManager(property.getTitle());
                    property.contributeActions(mainProperty, (IMenuManager)subMenu);
                    implementMenuManager.add((IContributionItem)subMenu);
                }
                ++n2;
            }
        } else {
            SubStylePropertyImpl[] subStylePropertyImplArray = this.m_properties;
            int n = this.m_properties.length;
            int n3 = 0;
            while (n3 < n) {
                SubStylePropertyImpl property = subStylePropertyImplArray[n3];
                property.contributeActions(mainProperty, (IMenuManager)implementMenuManager);
                ++n3;
            }
        }
        manager.appendToGroup("org.eclipse.wb.popup.group.layout", (IContributionItem)implementMenuManager);
    }

    public static void addStyleProperty(final XmlObjectInfo widget) {
        if (!(widget.getCreationSupport() instanceof ElementCreationSupport)) {
            return;
        }
        StylePropertyEditor.addClipboardSupport(widget);
        widget.addBroadcastListener((Object)new XmlObjectAddProperties(){
            private boolean m_propertyReady;
            private Property m_property;

            public void invoke(XmlObjectInfo object, List<Property> properties) throws Exception {
                if (object == widget) {
                    this.addStyleProperty(object, properties);
                }
            }

            private void addStyleProperty(XmlObjectInfo object, List<Property> properties) {
                if (!this.m_propertyReady) {
                    this.prepareProperty(object);
                    this.m_propertyReady = true;
                }
                if (this.m_property != null) {
                    properties.add(this.m_property);
                }
            }

            private void prepareProperty(XmlObjectInfo object) {
                StylePropertyEditor styleEditor = (StylePropertyEditor)((Object)object.getDescription().getArbitraryValue(StylePropertyEditor.class));
                if (styleEditor != null) {
                    styleEditor.setClassResolver(XwtStyleClassResolver.INSTANCE);
                    GenericPropertyDescription propertyDescription = new GenericPropertyDescription("style", "Style", Integer.TYPE, new ExpressionAccessor("x:Style"){

                        public Object getDefaultValue(XmlObjectInfo object) throws Exception {
                            return 0;
                        }
                    });
                    propertyDescription.setEditor((PropertyEditor)styleEditor);
                    this.m_property = new GenericPropertyImpl(object, propertyDescription);
                    this.m_property.setCategory(PropertyCategory.system((int)4));
                }
            }
        });
    }

    private static void addClipboardSupport(final XmlObjectInfo widget) {
        widget.addBroadcastListener((Object)new XmlObjectClipboardCopy(){

            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                Property property;
                if (object == widget && (property = object.getPropertyByTitle("Style")) != null && property.isModified()) {
                    final long style = ((StylePropertyEditor)property.getEditor()).getStyle(property);
                    commands.add(new ClipboardCommand(){
                        private static final long serialVersionUID = 0L;

                        public void execute(XmlObjectInfo object) throws Exception {
                            Property property = object.getPropertyByTitle("Style");
                            ((StylePropertyEditor)property.getEditor()).setStyleValue(property, style);
                        }
                    });
                }
            }
        });
    }
}

