/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.AbstractFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.FactoryAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SuperConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.ObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreationSupportUtils {
    private final JavaInfo m_javaInfo;
    private final CreationSupport m_creationSupport;

    public CreationSupportUtils(JavaInfo javaInfo) {
        this.m_javaInfo = javaInfo;
        this.m_creationSupport = javaInfo.getCreationSupport();
    }

    private ExpressionAccessor createAccessor(ParameterDescription parameter) {
        int index = parameter.getIndex();
        String defaultSource = parameter.getDefaultSource();
        if (this.m_creationSupport instanceof ConstructorCreationSupport) {
            return new ConstructorAccessor(index, defaultSource);
        }
        if (this.m_creationSupport instanceof ThisCreationSupport) {
            SuperConstructorInvocation invocation = ((ThisCreationSupport)this.m_creationSupport).getInvocation();
            return new SuperConstructorAccessor(invocation, index, defaultSource);
        }
        Assert.instanceOf(AbstractFactoryCreationSupport.class, (Object)this.m_creationSupport);
        return new FactoryAccessor(index, defaultSource);
    }

    private Expression getArgument(ParameterDescription parameter) {
        int index = parameter.getIndex();
        return this.getArguments().get(index);
    }

    private List<Expression> getArguments() {
        if (this.m_creationSupport instanceof ConstructorCreationSupport) {
            return DomGenerics.arguments(((ConstructorCreationSupport)this.m_creationSupport).getCreation());
        }
        if (this.m_creationSupport instanceof ThisCreationSupport) {
            SuperConstructorInvocation invocation = ((ThisCreationSupport)this.m_creationSupport).getInvocation();
            return DomGenerics.arguments(invocation);
        }
        Assert.instanceOf(AbstractFactoryCreationSupport.class, (Object)this.m_creationSupport);
        return DomGenerics.arguments(((AbstractFactoryCreationSupport)this.m_creationSupport).getInvocation());
    }

    public Property createProperty(ParameterDescription parameter) throws Exception {
        Expression argument;
        JavaInfo argumentJavaInfo;
        if (parameter.hasTrueTag("property.no")) {
            return null;
        }
        if (parameter.isParent() && (argumentJavaInfo = this.getArgumentJavaInfo(argument = this.getArgument(parameter))) != null) {
            ComplexProperty complexProperty = new ComplexProperty(parameter.getName(), "(properties)");
            complexProperty.setProperties(argumentJavaInfo.getProperties());
            return complexProperty;
        }
        PropertyEditor editor = parameter.getEditor();
        if (editor == null && CreationSupportUtils.shouldUseObjectPropertyEditor(parameter)) {
            editor = ObjectPropertyEditor.INSTANCE;
        }
        if (editor != null) {
            ExpressionAccessor accessor = this.createAccessor(parameter);
            ExpressionConverter converter = parameter.getConverter();
            GenericPropertyImpl property = new GenericPropertyImpl(this.m_javaInfo, parameter.getName(), new ExpressionAccessor[]{accessor}, Property.UNKNOWN_VALUE, converter, editor);
            property.setType(parameter.getType());
            return property;
        }
        return null;
    }

    private JavaInfo getArgumentJavaInfo(Expression argument) {
        JavaInfo argumentJavaInfo = this.m_javaInfo.getRootJava().getChildRepresentedBy((ASTNode)argument);
        if (argumentJavaInfo != null && argumentJavaInfo.getRoot() != this.m_javaInfo.getRoot()) {
            return null;
        }
        return argumentJavaInfo;
    }

    private static boolean shouldUseObjectPropertyEditor(ParameterDescription parameter) {
        Class<?> type = parameter.getType();
        return type != null && !type.isPrimitive();
    }

    public String getClipboardArguments(List<ParameterDescription> parameters) throws Exception {
        StringBuilder argumentsSource = new StringBuilder();
        List<Expression> arguments = this.getArguments();
        for (ParameterDescription parameter : parameters) {
            if (argumentsSource.length() != 0) {
                argumentsSource.append(", ");
            }
            String[] source = new String[1];
            Expression argument = arguments.get(parameter.getIndex());
            this.m_javaInfo.getBroadcastJava().clipboardCopy_Argument(this.m_javaInfo, parameter, argument, source);
            if (source[0] != null) {
                argumentsSource.append(source[0]);
                continue;
            }
            if (parameter.isParent()) {
                argumentsSource.append("%parent%");
                continue;
            }
            String argumentSource = this.getClipboardArgument(parameter);
            argumentsSource.append(argumentSource);
        }
        return argumentsSource.toString();
    }

    private String getClipboardArgument(ParameterDescription parameter) throws Exception {
        String argumentSource = null;
        Property argumentProperty = this.createProperty(parameter);
        if (argumentProperty instanceof GenericPropertyImpl) {
            argumentSource = ((GenericPropertyImpl)argumentProperty).getClipboardSource();
        }
        if (argumentSource == null) {
            argumentSource = parameter.getDefaultSource();
        }
        Assert.isNotNull((Object)argumentSource, (String)("No source for " + parameter.getIndex() + "-th argument of " + this.m_creationSupport.getNode()));
        return argumentSource;
    }
}

