/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;

public final class PackageSelectionDialogField
extends StringButtonDialogField
implements IDialogFieldListener {
    private IDialogFieldListener m_updateListener;
    private IPackageFragmentRoot m_root;
    private IPackageFragment m_package;

    public static PackageSelectionDialogField create(String label, String buttonLabel) {
        ButtonAdapter adapter = new ButtonAdapter();
        PackageSelectionDialogField field = new PackageSelectionDialogField(label, buttonLabel, adapter);
        adapter.setReceiver(field);
        return field;
    }

    private PackageSelectionDialogField(String label, String buttonLabel, IStringButtonAdapter adapter) {
        super(adapter);
        this.setLabelText(label);
        this.setButtonLabel(buttonLabel);
        this.setDialogFieldListener(this);
    }

    public void setUpdateListener(IDialogFieldListener updateListener) {
        this.m_updateListener = updateListener;
    }

    public void setCompilationUnit(ICompilationUnit unit) {
        IPackageFragment pkg = (IPackageFragment)unit.getParent();
        this.setPackage(pkg);
    }

    public IPackageFragmentRoot getRoot() {
        return this.m_root;
    }

    public void setRoot(IPackageFragmentRoot root) {
        this.m_root = root;
        this.updatePackage();
    }

    public IPackageFragment getPackage() {
        return this.m_package;
    }

    public void setPackage(IPackageFragment pkg) {
        this.m_package = pkg;
        if (this.m_package != null) {
            String newText = PackageSelectionDialogField.getPackageString(this.m_package);
            if (!this.getText().equals(newText)) {
                this.setText(newText);
            }
        }
        if (this.m_updateListener != null) {
            this.m_updateListener.dialogFieldChanged((DialogField)this);
        }
    }

    public void dialogFieldChanged(DialogField field) {
        this.updatePackage();
    }

    private void updatePackage() {
        IPackageFragment pkg = this.getPackageFromString(this.getText());
        this.setPackage(pkg);
    }

    private static String getPackageString(IPackageFragment pkg) {
        return pkg == null ? "" : pkg.getElementName();
    }

    private IPackageFragment getPackageFromString(String packageString) {
        if (this.m_root == null) {
            return null;
        }
        IPackageFragment packageFragment = this.m_root.getPackageFragment(packageString);
        if (packageFragment.exists()) {
            return packageFragment;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonAdapter
    implements IStringButtonAdapter {
        private PackageSelectionDialogField m_receiver;

        private ButtonAdapter() {
        }

        public void setReceiver(PackageSelectionDialogField receiver) {
            this.m_receiver = receiver;
        }

        public void changeControlPressed(DialogField field) {
            IPackageFragment selectedPackage;
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new JavaElementLabelProvider());
            dialog.setIgnoreCase(false);
            dialog.setTitle(Messages.PackageSelectionDialogField_dialogTitle);
            dialog.setMessage(Messages.PackageSelectionDialogField_dialogMessage);
            dialog.setElements(this.getPackagesList().toArray());
            if (dialog.open() == 0 && (selectedPackage = (IPackageFragment)dialog.getFirstResult()) != null) {
                this.m_receiver.setPackage(selectedPackage);
            }
        }

        private List<IPackageFragment> getPackagesList() {
            try {
                List packages = Lists.newArrayList();
                if (this.m_receiver.m_root != null) {
                    ButtonAdapter.addValidPackages(this.m_receiver.m_root, packages, Sets.newTreeSet());
                }
                return packages;
            }
            catch (JavaModelException e) {
                DesignerPlugin.log((Throwable)e);
                return Collections.emptyList();
            }
        }

        private static void addValidPackages(IPackageFragmentRoot root, List<IPackageFragment> packages, Set<String> addedPackageNames) throws JavaModelException {
            IJavaElement[] children = null;
            try {
                children = root.getChildren();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IPackageFragment) {
                    IPackageFragment packageFragment = (IPackageFragment)children[i];
                    String packageName = packageFragment.getElementName();
                    if ((addedPackageNames == null || !addedPackageNames.contains(packageName)) && ButtonAdapter.canAddPackage(packageFragment)) {
                        packages.add(packageFragment);
                        if (addedPackageNames != null) {
                            addedPackageNames.add(packageName);
                        }
                    }
                }
                ++i;
            }
        }

        public static boolean canAddPackageRoot(IPackageFragmentRoot root) throws JavaModelException {
            if (!root.exists()) {
                return false;
            }
            if (root.isArchive()) {
                return false;
            }
            if (root.isExternal()) {
                return false;
            }
            if (root.isReadOnly()) {
                return false;
            }
            return root.isStructureKnown();
        }

        private static boolean canAddPackage(IPackageFragment pkg) throws JavaModelException {
            if (!pkg.exists()) {
                return false;
            }
            if (pkg.isReadOnly()) {
                return false;
            }
            return pkg.isStructureKnown();
        }
    }
}

