/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.wizards.autobindings;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.DefaultAutomaticDatabindingProvider;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.DescriptorContainer;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.IAutomaticDatabindingProvider;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.IImageLoader;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.databinding.Activator;
import org.eclipse.wb.internal.swing.databinding.model.DataBindingsCodeUtils;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.wizards.autobindings.AutoBindingUpdateStrategyDescriptor;
import org.eclipse.wb.internal.swing.databinding.wizards.autobindings.ObservePropertyAdapter;
import org.eclipse.wb.internal.swing.databinding.wizards.autobindings.ObservePropertyAdapterLabelProvider;
import org.eclipse.wb.internal.swing.databinding.wizards.autobindings.SwingComponentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwingDatabindingProvider
extends DefaultAutomaticDatabindingProvider {
    private static DescriptorContainer m_componentContainer;
    private static DescriptorContainer m_strategyContainer;

    public static IAutomaticDatabindingProvider create() {
        try {
            if (m_componentContainer == null && m_strategyContainer == null) {
                InputStream stream = Activator.getFile("templates/SwingEditors.xml");
                Map containers = DescriptorContainer.parseDescriptors((InputStream)stream, (ClassLoader)SwingDatabindingProvider.class.getClassLoader(), (IImageLoader)new IImageLoader(){

                    public Image getImage(String name) {
                        return Activator.getImage(name);
                    }
                });
                IOUtils.closeQuietly((InputStream)stream);
                m_componentContainer = (DescriptorContainer)containers.get("Swing.Components");
                m_strategyContainer = (DescriptorContainer)containers.get("AutoBinding.UpdateStrategy");
            }
            return new SwingDatabindingProvider(m_componentContainer, m_strategyContainer);
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
            return null;
        }
    }

    private SwingDatabindingProvider(DescriptorContainer widgetContainer, DescriptorContainer strategyContainer) {
        super(widgetContainer, strategyContainer);
    }

    public String[] getSuperClasses() {
        return new String[]{"javax.swing.JPanel", "javax.swing.JDialog", "javax.swing.JFrame"};
    }

    public String getInitialSuperClass() {
        return "javax.swing.JPanel";
    }

    public void configure(ChooseClassAndPropertiesConfiguration configuration) {
        configuration.setPropertiesLabelProvider((IBaseLabelProvider)new ObservePropertyAdapterLabelProvider());
        configuration.setValueScope("beans");
    }

    protected List<PropertyAdapter> getProperties0(Class<?> choosenClass) throws Exception {
        List adapters = Lists.newArrayList();
        BeanSupport beanSupport = new BeanSupport();
        beanSupport.doAddELProperty(false);
        beanSupport.doAddSelfProperty(false);
        ClassGenericType objectType = new ClassGenericType(choosenClass, null, null);
        for (ObserveInfo property : beanSupport.createProperties(null, objectType)) {
            adapters.add(new ObservePropertyAdapter(property));
        }
        return adapters;
    }

    public InputStream getTemplateFile(String superClassName) {
        return Activator.getFile("templates/" + ClassUtils.getShortClassName((String)superClassName) + ".jvt");
    }

    public String performSubstitutions(String code, NewTypeWizardPage.ImportsManager imports) throws Exception {
        boolean blockMode = SwingDatabindingProvider.useBlockMode();
        boolean lazyVariables = SwingDatabindingProvider.createLazyVariables();
        DataBindingsCodeUtils.ensureDBLibraries(this.m_javaProject);
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(CoreUtils.useGenerics((IJavaProject)this.m_javaProject));
        Collection importList = Sets.newHashSet();
        importList.add("java.awt.GridBagLayout");
        importList.add("java.awt.GridBagConstraints");
        importList.add("java.awt.Insets");
        importList.add("javax.swing.JLabel");
        importList.add("org.jdesktop.beansbinding.AutoBinding");
        importList.add("org.jdesktop.beansbinding.Bindings");
        importList.add("org.jdesktop.beansbinding.BeanProperty");
        if (!generationSupport.useGenerics()) {
            importList.add("org.jdesktop.beansbinding.Property");
        }
        String beanClassName = this.m_beanClass.getName().replace('$', '.');
        String beanClassShortName = ClassUtils.getShortClassName((String)beanClassName);
        String fieldPrefix = JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.fieldPrefixes");
        String fieldName = String.valueOf(fieldPrefix) + StringUtils.uncapitalize((String)beanClassShortName);
        code = StringUtils.replace((String)code, (String)"%BeanClass%", (String)beanClassName);
        code = ReflectionUtils.getConstructorBySignature((Class)this.m_beanClass, (String)"<init>()") == null ? StringUtils.replace((String)code, (String)"%BeanField%", (String)fieldName) : StringUtils.replace((String)code, (String)"%BeanField%", (String)(String.valueOf(fieldName) + " = new " + beanClassName + "()"));
        IPreferenceStore preferences = ToolkitProvider.DESCRIPTION.getPreferences();
        String accessPrefix = preferences.getBoolean("variable.fieldUnique.prefixThis") ? "this." : "";
        String beanFieldAccess = String.valueOf(accessPrefix) + fieldName;
        code = StringUtils.replace((String)code, (String)"%BeanName%", (String)StringUtils.capitalize((String)beanClassShortName));
        code = StringUtils.replace((String)code, (String)"%BeanFieldAccess%", (String)(String.valueOf(accessPrefix) + fieldName));
        final List properties = Lists.newArrayList();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CollectionUtils.addAll((Collection)properties, (Object[])SwingDatabindingProvider.this.m_propertiesViewer.getCheckedElements());
            }
        });
        StringBuffer componentFields = new StringBuffer();
        StringBuffer components = new StringBuffer();
        String swingContainer = StringUtils.substringBetween((String)code, (String)"%Components%", (String)"%");
        String swingContainerWithDot = "this".equals(swingContainer) ? "" : String.valueOf(swingContainer) + ".";
        int propertiesCount = properties.size();
        int lastPropertyIndex = propertiesCount - 1;
        StringBuffer bindings = new StringBuffer();
        components.append("\t\tGridBagLayout gridBagLayout = new GridBagLayout();\r\n");
        components.append("\t\tgridBagLayout.columnWidths = new int[]{0, 0, 0};\r\n");
        components.append("\t\tgridBagLayout.rowHeights = new int[]{" + StringUtils.repeat((String)"0, ", (int)propertiesCount) + "0};\r\n");
        components.append("\t\tgridBagLayout.columnWeights = new double[]{0.0, 1.0, 1.0E-4};\r\n");
        components.append("\t\tgridBagLayout.rowWeights = new double[]{" + StringUtils.repeat((String)"0.0, ", (int)propertiesCount) + "1.0E-4};\r\n");
        components.append("\t\t" + swingContainerWithDot + "setLayout(gridBagLayout);\r\n");
        StringBuffer group = new StringBuffer();
        generationSupport.generateLocalName(new String[]{"bindingGroup"});
        StringBuffer lazy = new StringBuffer();
        int i = 0;
        while (i < propertiesCount) {
            String index = Integer.toString(i);
            PropertyAdapter property = (PropertyAdapter)properties.get(i);
            Object[] editorData = (Object[])this.m_propertyToEditor.get(property);
            SwingComponentDescriptor componentDescriptor = (SwingComponentDescriptor)((Object)editorData[0]);
            String propertyName = property.getName();
            SwingDatabindingProvider.addLabelCode(componentFields, components, lazy, swingContainerWithDot, blockMode, lazyVariables, propertyName, index);
            String componentClassName = componentDescriptor.getComponentClass();
            String componentShortClassName = ClassUtils.getShortClassName((String)componentClassName);
            String componentFieldName = String.valueOf(fieldPrefix) + propertyName + componentShortClassName;
            String componentFieldAccess = String.valueOf(accessPrefix) + componentFieldName;
            String componentLazyAccess = "get" + StringUtils.capitalize((String)propertyName) + componentShortClassName + "()";
            String componentAccess = lazyVariables ? componentLazyAccess : componentFieldAccess;
            importList.add(componentClassName);
            componentFields.append("\r\nfield\r\n\tprivate " + componentShortClassName + " " + componentFieldName + ";");
            SwingDatabindingProvider.addComponentCode(components, lazy, swingContainerWithDot, blockMode, lazyVariables, componentShortClassName, componentFieldAccess, componentLazyAccess, index);
            AutoBindingUpdateStrategyDescriptor strategyDescriptor = (AutoBindingUpdateStrategyDescriptor)((Object)editorData[1]);
            String modelPropertyName = generationSupport.generateLocalName(new String[]{propertyName, "Property"});
            String targetPropertyName = generationSupport.generateLocalName(new String[]{componentDescriptor.getName(1), "Property"});
            String bindingName = generationSupport.generateLocalName(new String[]{"autoBinding"});
            String modelGeneric = null;
            String targetGeneric = null;
            if (generationSupport.useGenerics()) {
                modelGeneric = String.valueOf(beanClassName) + ", " + GenericUtils.convertPrimitiveType(property.getType().getName());
                bindings.append("\t\tBeanProperty<" + modelGeneric + "> ");
            } else {
                bindings.append("\t\tProperty ");
            }
            bindings.append(String.valueOf(modelPropertyName) + " = BeanProperty.create(\"" + propertyName + "\");\r\n");
            if (generationSupport.useGenerics()) {
                targetGeneric = String.valueOf(componentDescriptor.getComponentClass()) + ", " + componentDescriptor.getPropertyClass();
                bindings.append("\t\tBeanProperty<" + targetGeneric + "> ");
            } else {
                bindings.append("\t\tProperty ");
            }
            bindings.append(String.valueOf(targetPropertyName) + " = BeanProperty.create(\"" + componentDescriptor.getName(1) + "\");\r\n");
            bindings.append("\t\tAutoBinding");
            if (generationSupport.useGenerics()) {
                bindings.append("<" + modelGeneric + ", " + targetGeneric + ">");
            }
            bindings.append(" " + bindingName + " = Bindings.createAutoBinding(" + strategyDescriptor.getSourceCode() + ", " + beanFieldAccess + ", " + modelPropertyName + ", " + componentAccess + ", " + targetPropertyName + ");\r\n");
            bindings.append("\t\t" + bindingName + ".bind();");
            group.append("\t\tbindingGroup.addBinding(" + bindingName + ");");
            if (i < lastPropertyIndex) {
                componentFields.append("\r\n");
                components.append("\r\n");
                bindings.append("\r\n\t\t//\r\n");
                group.append("\r\n");
            }
            ++i;
        }
        code = StringUtils.replace((String)code, (String)"%ComponentFields%", (String)componentFields.toString());
        code = StringUtils.replace((String)code, (String)("%Components%" + swingContainer + "%"), (String)components.toString());
        code = StringUtils.replace((String)code, (String)"%Bindings%", (String)bindings.toString());
        code = StringUtils.replace((String)code, (String)"%Group%", (String)group.toString());
        code = StringUtils.replace((String)code, (String)"%LAZY%", (String)lazy.toString());
        for (String qualifiedTypeName : importList) {
            imports.addImport(qualifiedTypeName);
        }
        return code;
    }

    private static void addLabelCode(StringBuffer componentFields, StringBuffer components, StringBuffer lazy, String swingContainerWithDot, boolean blockMode, boolean lazyVariables, String propertyName, String index) {
        String componentAccess = null;
        if (lazyVariables) {
            String fieldPrefix = JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.fieldPrefixes");
            String label = String.valueOf(propertyName) + "Label";
            componentFields.append("\r\nfield\r\n\tprivate JLabel " + fieldPrefix + label + ";\r\n");
            IPreferenceStore preferences = ToolkitProvider.DESCRIPTION.getPreferences();
            String accessPrefix = preferences.getBoolean("variable.fieldUnique.prefixThis") ? "this." : "";
            componentAccess = "get" + StringUtils.capitalize((String)label) + "()";
            String labelAccess = String.valueOf(accessPrefix) + fieldPrefix + label;
            lazy.append("\r\nmethod\r\n\tprivate JLabel " + componentAccess + " {\r\n\t\tif (" + labelAccess + " == null) {\r\n\t\t\t" + labelAccess + " = new JLabel(\"" + StringUtils.capitalize((String)propertyName) + ":\");\r\n\t\t}\r\n\t\treturn " + labelAccess + ";\r\n\t}\r\n\r\n");
        }
        if (blockMode) {
            components.append("\t\t{\r\n");
            if (!lazyVariables) {
                componentAccess = "label";
                components.append("\t\t\tJLabel label = new JLabel(\"" + StringUtils.capitalize((String)propertyName) + ":\");\r\n");
            }
            components.append("\t\t\tGridBagConstraints gbc = new GridBagConstraints();\r\n");
            components.append("\t\t\tgbc.insets = new Insets(5, 5, 5, 5);\r\n");
            components.append("\t\t\tgbc.gridx = 0;\r\n");
            components.append("\t\t\tgbc.gridy = " + index + ";\r\n");
            components.append("\t\t\t" + swingContainerWithDot + "add(" + componentAccess + ", gbc);\r\n");
            components.append("\t\t}\r\n");
        } else {
            components.append("\t\r\n");
            if (!lazyVariables) {
                componentAccess = String.valueOf(propertyName) + "Label";
                components.append("\t\tJLabel " + componentAccess + " = new JLabel(\"" + StringUtils.capitalize((String)propertyName) + ":\");\r\n");
            }
            String gbc = "labelGbc_" + index;
            components.append("\t\tGridBagConstraints " + gbc + " = new GridBagConstraints();\r\n");
            components.append("\t\t" + gbc + ".insets = new Insets(5, 5, 5, 5);\r\n");
            components.append("\t\t" + gbc + ".gridx = 0;\r\n");
            components.append("\t\t" + gbc + ".gridy = " + index + ";\r\n");
            components.append("\t\t" + swingContainerWithDot + "add(" + componentAccess + ", " + gbc + ");\r\n");
            components.append("\t\r\n");
        }
    }

    private static boolean useBlockMode() {
        StatementGeneratorDescription statement = SwingToolkitDescription.INSTANCE.getGenerationSettings().getStatement();
        return statement != null && "Block".equals(statement.getName());
    }

    private static boolean createLazyVariables() {
        VariableSupportDescription variable = SwingToolkitDescription.INSTANCE.getGenerationSettings().getVariable();
        return variable != null && "Lazy".equals(variable.getName());
    }

    private static void addComponentCode(StringBuffer components, StringBuffer lazy, String swingContainerWithDot, boolean blockMode, boolean lazyVariable, String componentShortClassName, String componentFieldAccess, String componentLazyAccess, String index) {
        String componentAccess = null;
        if (lazyVariable) {
            componentAccess = componentLazyAccess;
            lazy.append("\r\nmethod\r\n\tprivate " + componentShortClassName + " " + componentLazyAccess + " {\r\n\t\tif (" + componentFieldAccess + " == null) {\r\n\t\t\t" + componentFieldAccess + " = new " + componentShortClassName + "();\r\n\t\t}\r\n\t\treturn " + componentFieldAccess + ";\r\n\t}\r\n\r\n");
        }
        if (blockMode) {
            components.append("\t\t{\r\n");
            if (!lazyVariable) {
                componentAccess = componentFieldAccess;
                components.append("\t\t\t " + componentFieldAccess + " = new " + componentShortClassName + "();\r\n");
            }
            components.append("\t\t\tGridBagConstraints gbc = new GridBagConstraints();\r\n");
            components.append("\t\t\tgbc.insets = new Insets(5, 0, 5, 5);\r\n");
            components.append("\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\r\n");
            components.append("\t\t\tgbc.gridx = 1;\r\n");
            components.append("\t\t\tgbc.gridy = " + index + ";\r\n");
            components.append("\t\t\t" + swingContainerWithDot + "add(" + componentAccess + ", gbc);\r\n");
            components.append("\t\t}");
        } else {
            components.append("\t\r\n");
            if (!lazyVariable) {
                componentAccess = componentFieldAccess;
                components.append("\t\t " + componentFieldAccess + " = new " + componentShortClassName + "();\r\n");
            }
            String gbc = "componentGbc_" + index;
            components.append("\t\tGridBagConstraints " + gbc + " = new GridBagConstraints();\r\n");
            components.append("\t\t" + gbc + ".insets = new Insets(5, 0, 5, 5);\r\n");
            components.append("\t\t" + gbc + ".fill = GridBagConstraints.HORIZONTAL;\r\n");
            components.append("\t\t" + gbc + ".gridx = 1;\r\n");
            components.append("\t\t" + gbc + ".gridy = " + index + ";\r\n");
            components.append("\t\t" + swingContainerWithDot + "add(" + componentAccess + ", " + gbc + ");\r\n");
            components.append("\t\t");
        }
    }
}

