/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.surround;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.model.util.surround.ISurroundProcessor;
import org.eclipse.wb.internal.core.model.util.surround.ISurroundTarget;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.ui.IActionSingleton;
import org.eclipse.wb.internal.core.utils.ui.MenuManagerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SurroundSupport<C extends AbstractComponentInfo, T extends AbstractComponentInfo> {
    private static final String SURROUND_POINT = "org.eclipse.wb.core.surroundWith";
    private final C m_sourceContainer;
    private final Class<T> m_componentClass;

    public SurroundSupport(C sourceContainer, Class<T> componentClass) {
        this.m_sourceContainer = sourceContainer;
        this.m_componentClass = componentClass;
        this.m_sourceContainer.addBroadcastListener((Object)new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (objects != null && object != null) {
                    boolean shouldExecute = objects.indexOf(object) == 0;
                    SurroundSupport.this.addSurroundMenu(objects, shouldExecute, manager);
                }
            }
        });
    }

    private void addSurroundMenu(List<? extends ObjectInfo> objects, boolean shouldExecute, IMenuManager manager) throws Exception {
        if (objects.isEmpty()) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        Set selectedComponents = Sets.newHashSet();
        for (ObjectInfo objectInfo : objects) {
            if (objectInfo.getParent() != this.m_sourceContainer) {
                return;
            }
            if (!this.m_componentClass.isAssignableFrom(objectInfo.getClass())) {
                return;
            }
            AbstractComponentInfo component = (AbstractComponentInfo)objectInfo;
            selectedComponents.add(component);
        }
        List list = Lists.newArrayList();
        for (ObjectInfo component : this.m_sourceContainer.getChildren()) {
            if (!selectedComponents.contains(component)) continue;
            list.add((AbstractComponentInfo)component);
        }
        if (!this.validateComponents(list)) {
            return;
        }
        MenuManagerEx surroundManager = new MenuManagerEx(ModelMessages.SurroundSupport_surorundManager);
        surroundManager.setImage(DesignerPlugin.getImage((String)"actions/surround/surround.png"));
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IContributionItem)surroundManager);
        this.addSurroundActions(surroundManager, list);
    }

    private void addSurroundActions(MenuManagerEx surroundManager, List<T> components) throws Exception {
        List elements = ExternalFactoriesHelper.getElements((String)SURROUND_POINT, (String)"target");
        String sourceToolkitID = ((JavaInfo)((Object)this.m_sourceContainer)).getDescription().getToolkit().getId();
        for (IConfigurationElement element : elements) {
            ISurroundTarget target;
            if (!ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"toolkit").equals(sourceToolkitID) || !(target = (ISurroundTarget)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class")).validate(components)) continue;
            surroundManager.add((IAction)new SurroundAction(components, target));
        }
    }

    protected boolean isActive() {
        return true;
    }

    protected boolean validateComponents(List<T> components) throws Exception {
        return true;
    }

    protected abstract void addContainer(C var1, List<T> var2) throws Exception;

    protected void moveComponent(ISurroundTarget<C, T> target, C container, T component) throws Exception {
        target.move(container, component);
    }

    protected void moveDone(C container, List<T> components) throws Exception {
    }

    private List<ISurroundProcessor<C, T>> getSurroundProcessors() {
        List typedProcessors = Lists.newArrayList();
        List elements = ExternalFactoriesHelper.getElements((String)SURROUND_POINT, (String)"processor");
        String sourceToolkitID = ((JavaInfo)((Object)this.m_sourceContainer)).getDescription().getToolkit().getId();
        for (IConfigurationElement element : elements) {
            if (!ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"toolkit").equals(sourceToolkitID)) continue;
            ISurroundProcessor processor = (ISurroundProcessor)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
            typedProcessors.add(processor);
        }
        return typedProcessors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SurroundAction
    extends ObjectInfoAction
    implements IActionSingleton {
        private final List<T> m_components;
        private final ISurroundTarget<C, T> m_target;
        private final AstEditor m_editor;

        public SurroundAction(List<T> components, ISurroundTarget<C, T> target) throws Exception {
            super((ObjectInfo)SurroundSupport.this.m_sourceContainer);
            this.m_components = components;
            this.m_target = target;
            this.m_editor = SurroundSupport.this.m_sourceContainer.getEditor();
            this.setText(this.m_target.getText(this.m_editor));
            this.setIcon(this.m_target.getIcon(this.m_editor));
        }

        protected void runEx() throws Exception {
            final AbstractComponentInfo container = (AbstractComponentInfo)((Object)this.m_target.createContainer(this.m_editor));
            SurroundSupport.this.addContainer(container, this.m_components);
            this.m_target.afterContainerAdd(container, this.m_components);
            ObjectInfo rootObject = container.getRoot();
            rootObject.putArbitraryValue((Object)"ObjectInfo: don't send refreshed() broadcast", (Object)Boolean.FALSE);
            try {
                rootObject.refresh();
            }
            finally {
                rootObject.removeArbitraryValue((Object)"ObjectInfo: don't send refreshed() broadcast");
            }
            this.moveComponents((Object)((Object)container));
            SurroundSupport.this.moveDone(container, this.m_components);
            ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    container.getBroadcastObject().select((List)ImmutableList.of((Object)((Object)container)));
                }
            });
        }

        private void moveComponents(C container) throws Exception {
            for (ISurroundProcessor processor : SurroundSupport.this.getSurroundProcessors()) {
                if (!processor.filter(SurroundSupport.this.m_sourceContainer, container)) continue;
                processor.move(SurroundSupport.this.m_sourceContainer, container, this.m_components);
                return;
            }
            this.m_target.beforeComponentsMove(container, this.m_components);
            for (AbstractComponentInfo component : this.m_components) {
                SurroundSupport.this.moveComponent(this.m_target, container, component);
            }
        }
    }
}

