/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.FieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyVariableSupportUtils {
    public static boolean canConvert(JavaInfo javaInfo) {
        boolean canConvert = true;
        VariableSupport variableSupport = javaInfo.getVariableSupport();
        return canConvert &= variableSupport.canConvertLocalToField() || variableSupport instanceof LazyVariableSupport || variableSupport instanceof FieldVariableSupport;
    }

    public static void convert(JavaInfo javaInfo) throws Exception {
        VariableSupport variableSupport = javaInfo.getVariableSupport();
        if (variableSupport instanceof LazyVariableSupport) {
            return;
        }
        if (variableSupport.canConvertLocalToField()) {
            variableSupport.convertLocalToField();
            variableSupport = javaInfo.getVariableSupport();
        }
        if (!(variableSupport instanceof FieldVariableSupport)) {
            throw new IllegalStateException();
        }
        LazyVariableSupport.LazyVariableInformation variableInformation = LazyVariableSupportUtils.convertAsField(javaInfo);
        LazyVariableSupport lazyVariableSupport = new LazyVariableSupport(javaInfo, variableInformation);
        javaInfo.setVariableSupport(lazyVariableSupport);
    }

    private static LazyVariableSupport.LazyVariableInformation convertAsField(JavaInfo javaInfo) throws Exception {
        FieldVariableSupport fieldVariableSupport = (FieldVariableSupport)javaInfo.getVariableSupport();
        String fieldName = fieldVariableSupport.getName();
        Expression creation = (Expression)javaInfo.getCreationSupport().getNode();
        MethodDeclaration accessor = LazyVariableSupportUtils.addMethod(javaInfo, AstNodeUtils.getEnclosingType((ASTNode)creation), fieldName);
        IfStatement ifStatement = (IfStatement)accessor.getBody().statements().get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ExpressionStatement expressionStatement = (ExpressionStatement)thenBlock.statements().get(0);
        Assignment assignment = (Assignment)expressionStatement.getExpression();
        AstEditor editor = javaInfo.getEditor();
        StatementTarget target = new StatementTarget((ASTNode)assignment, false);
        List moveStatements = Lists.newArrayList();
        List replaceNodes = Lists.newArrayList();
        LazyVariableSupportUtils.collectNodesToEdit(javaInfo, moveStatements, replaceNodes, target);
        moveStatements.remove(AstNodeUtils.getEnclosingStatement((ASTNode)creation));
        replaceNodes.remove(creation);
        Assert.isTrue((boolean)LazyVariableSupportUtils.canMoveNode(target, javaInfo, (ASTNode)creation));
        String replacementSource = editor.getSource((ASTNode)creation);
        NullLiteral newNullLiteral = creation.getAST().newNullLiteral();
        AstEditor.replaceNode((ASTNode)creation, (ASTNode)newNullLiteral);
        editor.removeEnclosingStatement((ASTNode)newNullLiteral);
        Expression originalNode = assignment.getRightHandSide();
        int startPosition = originalNode.getStartPosition();
        editor.replaceExpression(originalNode, replacementSource);
        AstNodeUtils.moveNode((ASTNode)creation, startPosition);
        assignment.setRightHandSide(creation);
        List blocks = Lists.newArrayList();
        for (Statement statement : moveStatements) {
            Block block = AstNodeUtils.getEnclosingBlock((ASTNode)statement);
            if (blocks.contains(block)) continue;
            blocks.add(block);
        }
        Collections.sort(blocks, AstNodeUtils.SORT_BY_REVERSE_POSITION);
        for (Object block : blocks) {
            List<Statement> blockStatements = DomGenerics.statements((Block)block);
            if (!moveStatements.containsAll(blockStatements) || !(block.getParent() instanceof Block)) continue;
            moveStatements.removeAll(blockStatements);
            moveStatements.add(block);
        }
        Object[] statements = moveStatements.toArray(new Statement[moveStatements.size()]);
        Arrays.sort(statements, AstNodeUtils.SORT_BY_POSITION);
        moveStatements = Lists.newArrayList((Object[])statements);
        for (Statement moveStatement : moveStatements) {
            editor.moveStatement(moveStatement, target);
            target = new StatementTarget(moveStatement, false);
        }
        String invocationSource = String.valueOf(accessor.getName().getIdentifier()) + "()";
        List<ASTNode> relatedNodes = javaInfo.getRelatedNodes();
        for (ASTNode replaceNode : replaceNodes) {
            if (!relatedNodes.contains(replaceNode)) continue;
            Expression replaceExpression = editor.replaceExpression((Expression)replaceNode, invocationSource);
            relatedNodes.remove(replaceNode);
            javaInfo.addRelatedNode((ASTNode)replaceExpression);
        }
        return new LazyVariableSupport.LazyVariableInformation(accessor, assignment.getLeftHandSide(), creation);
    }

    private static void collectNodesToEdit(JavaInfo javaInfo, List<Statement> moveStatements, List<ASTNode> replaceNodes, StatementTarget target) throws Exception {
        for (ASTNode relatedNode : javaInfo.getRelatedNodes()) {
            Statement statement = AstNodeUtils.getEnclosingStatement(relatedNode);
            if (moveStatements.contains(statement)) continue;
            if (LazyVariableSupportUtils.canMoveNode(target, javaInfo, relatedNode)) {
                moveStatements.add(statement);
                continue;
            }
            replaceNodes.add(relatedNode);
        }
        List children = Lists.newArrayList(javaInfo.getChildrenJava());
        javaInfo.getBroadcastJava().variable_addStatementsToMove(javaInfo, children);
        for (JavaInfo child : children) {
            LazyVariableSupportUtils.collectNodesToEdit(child, moveStatements, replaceNodes, target);
        }
    }

    private static boolean canMoveNode(StatementTarget target, JavaInfo javaInfo, ASTNode node) {
        MethodInvocation invocation;
        if (!(node instanceof Expression)) {
            return true;
        }
        if (node instanceof MethodInvocation && !LazyVariableSupportUtils.canMoveInvocation(target, javaInfo, invocation = (MethodInvocation)node)) {
            return false;
        }
        return LazyVariableSupportUtils.canMoveNode(target, javaInfo, node.getParent());
    }

    private static boolean canMoveInvocation(StatementTarget target, JavaInfo javaInfo, MethodInvocation invocation) {
        Expression invocationExpression = invocation.getExpression();
        if (invocationExpression == null) {
            return false;
        }
        if (!javaInfo.isRepresentedBy((ASTNode)invocationExpression)) {
            return false;
        }
        List<Expression> expressions = DomGenerics.arguments(invocation);
        for (Expression expression : expressions) {
            JavaInfo expressionJavaInfo;
            if (LazyVariableSupportUtils.isRepresentedByOrChild(javaInfo, (ASTNode)expression) || (expressionJavaInfo = javaInfo.getRootJava().getChildRepresentedBy((ASTNode)expression)) == null || expressionJavaInfo.getVariableSupport() instanceof LazyVariableSupport || JavaInfoUtils.isCreatedAtTarget(expressionJavaInfo, new NodeTarget(target))) continue;
            return false;
        }
        return true;
    }

    private static boolean isRepresentedByOrChild(JavaInfo javaInfo, ASTNode node) {
        boolean represented = javaInfo.isRepresentedBy(node);
        for (JavaInfo childJavaInfo : javaInfo.getChildrenJava()) {
            if (represented) {
                return true;
            }
            represented |= LazyVariableSupportUtils.isRepresentedByOrChild(childJavaInfo, node);
        }
        return represented;
    }

    private static MethodDeclaration addMethod(JavaInfo javaInfo, TypeDeclaration typeDeclaration, String fieldName) throws Exception {
        AstEditor editor = javaInfo.getEditor();
        String methodName = LazyVariableSupportUtils.getExpectedMethodName(javaInfo, fieldName);
        methodName = editor.getUniqueMethodName(methodName);
        String className = ReflectionUtils.getCanonicalName(javaInfo.getDescription().getComponentClass());
        BodyDeclarationTarget bodyTarget = new BodyDeclarationTarget(typeDeclaration, false);
        String modifiers = LazyVariableSupport.prefMethodModifier(javaInfo);
        if (LazyVariableSupportUtils.isStaticContext(javaInfo, javaInfo.getCreationSupport().getNode().getStartPosition())) {
            modifiers = String.valueOf(modifiers) + "static ";
        }
        String header = String.valueOf(modifiers) + className + " " + methodName + "()";
        List bodyLines = Lists.newArrayList();
        bodyLines.add("if (" + fieldName + " == null) {");
        bodyLines.add("\t" + fieldName + " = null;");
        bodyLines.add("}");
        bodyLines.add("return " + fieldName + ";");
        return editor.addMethodDeclaration(header, bodyLines, bodyTarget);
    }

    public static boolean isStaticContext(JavaInfo javaInfo, int position) {
        MethodDeclaration method = javaInfo.getEditor().getEnclosingMethod(position);
        return AstNodeUtils.isStatic((BodyDeclaration)method);
    }

    public static String getExpectedMethodName(JavaInfo javaInfo, String fieldName) {
        String strippedFieldName = new VariableUtils(javaInfo).stripPrefixSuffix(fieldName, "org.eclipse.jdt.core.codeComplete.fieldPrefixes", "org.eclipse.jdt.core.codeComplete.fieldSuffixes");
        return "get" + StringUtils.capitalize((String)strippedFieldName);
    }

    public static void setLazyVariable(JavaInfo javaInfo) throws Exception {
        LazyVariableSupport.LazyVariableInformation lazyInformation;
        ASTNode creationNode = javaInfo.getCreationSupport().getNode();
        MethodDeclaration method = AstNodeUtils.getEnclosingMethod(creationNode);
        if (method != null && (lazyInformation = LazyVariableSupportUtils.getInformation(method)) != null && lazyInformation.getCreation() == creationNode) {
            javaInfo.setVariableSupport(new LazyVariableSupport(javaInfo, lazyInformation));
        }
    }

    public static LazyVariableSupport.LazyVariableInformation getInformation(MethodDeclaration method) {
        List<Statement> statements;
        if (method.parameters().isEmpty() && LazyVariableSupportUtils.isNotAbstract(method) && (statements = DomGenerics.statements(method.getBody())).size() == 2 && statements.get(0) instanceof IfStatement && statements.get(1) instanceof ReturnStatement) {
            IfStatement ifStatement = (IfStatement)statements.get(0);
            ReturnStatement returnStatement = (ReturnStatement)statements.get(1);
            Expression returnExpression = returnStatement.getExpression();
            if (returnExpression == null) {
                return null;
            }
            if (ifStatement.getThenStatement() instanceof Block && ifStatement.getElseStatement() == null && ifStatement.getExpression() instanceof InfixExpression) {
                IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)returnExpression);
                InfixExpression condition = (InfixExpression)ifStatement.getExpression();
                if (variableBinding != null && variableBinding.isField() && condition.getOperator() == InfixExpression.Operator.EQUALS && condition.getRightOperand() instanceof NullLiteral && LazyVariableSupportUtils.sameVariables(condition.getLeftOperand(), returnExpression)) {
                    Block block = (Block)ifStatement.getThenStatement();
                    return LazyVariableSupportUtils.getInformation(method, block, returnExpression);
                }
            }
        }
        return null;
    }

    private static boolean isNotAbstract(MethodDeclaration method) {
        return method.getBody() != null;
    }

    private static LazyVariableSupport.LazyVariableInformation getInformation(MethodDeclaration method, Block thenBlock, Expression variable) {
        List<Statement> thenStatements = DomGenerics.statements(thenBlock);
        for (Statement thenStatement : thenStatements) {
            LazyVariableSupport.LazyVariableInformation information = LazyVariableSupportUtils.getInformation(method, variable, thenStatement);
            if (information == null) continue;
            return information;
        }
        return null;
    }

    private static LazyVariableSupport.LazyVariableInformation getInformation(MethodDeclaration method, Expression variable, Statement thenStatement) {
        Assignment assignment;
        Expression assignmentVariable;
        ExpressionStatement expressionStatement;
        if (thenStatement instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)thenStatement;
            return LazyVariableSupportUtils.getInformation(method, tryStatement.getBody(), variable);
        }
        if (thenStatement instanceof ExpressionStatement && (expressionStatement = (ExpressionStatement)thenStatement).getExpression() instanceof Assignment && LazyVariableSupportUtils.sameVariables(assignmentVariable = (assignment = (Assignment)expressionStatement.getExpression()).getLeftHandSide(), variable)) {
            return new LazyVariableSupport.LazyVariableInformation(method, assignmentVariable, assignment.getRightHandSide());
        }
        return null;
    }

    private static boolean sameVariables(Expression expression_1, Expression expression_2) {
        String source_1 = expression_1.toString();
        String source_2 = expression_2.toString();
        return source_1.equals(source_2);
    }
}

