/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.AbstractBrowseImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.SrcImageResource;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;

final class SrcPackageImageContainer
implements IImageContainer {
    private final IPackageFragment m_packageFragment;
    private final SrcImageResource[] m_resources;

    public SrcPackageImageContainer(String id, IPackageFragmentRoot packageFragmentRoot, IPackageFragment packageFragment) throws Exception {
        Object[] nonJavaResources;
        this.m_packageFragment = packageFragment;
        List resources = Lists.newArrayList();
        Object[] objectArray = nonJavaResources = this.m_packageFragment.getNonJavaResources();
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile resource;
            String extension;
            Object nonJavaResource = objectArray[n2];
            if (nonJavaResource instanceof IFile && AbstractBrowseImagePage.isImageExtension(extension = (resource = (IFile)nonJavaResource).getLocation().getFileExtension())) {
                SrcImageResource imageResource = new SrcImageResource(id, packageFragmentRoot, resource);
                resources.add(imageResource);
            }
            ++n2;
        }
        this.m_resources = resources.toArray(new SrcImageResource[resources.size()]);
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
    }

    public String getName() {
        return this.m_packageFragment.getElementName();
    }

    public IImageElement[] elements() {
        return this.m_resources;
    }

    boolean isEmpty() {
        return this.m_resources.length == 0;
    }

    void dispose() {
        SrcImageResource[] srcImageResourceArray = this.m_resources;
        int n = this.m_resources.length;
        int n2 = 0;
        while (n2 < n) {
            SrcImageResource resource = srcImageResourceArray[n2];
            resource.dispose();
            ++n2;
        }
    }
}

