/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core;

import java.io.InputStream;
import java.security.Permission;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.BundleResourceProvider;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.preferences.PreferenceToSystemForwarder;
import org.eclipse.wb.internal.core.utils.product.ProductInfo;
import org.eclipse.wb.os.OSSupport;
import org.osgi.framework.BundleContext;

public class DesignerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wb.core";
    private static DesignerPlugin m_plugin;
    private static boolean m_ctrlPressed;
    private static boolean m_shiftPressed;
    private static boolean m_displayExceptionOnConsole;
    private IStatus m_lastStatus;
    private static final BundleResourceProvider m_resourceProvider;
    private static boolean m_preEditorConfigured;

    static {
        m_displayExceptionOnConsole = true;
        m_resourceProvider = BundleResourceProvider.get(PLUGIN_ID);
        m_preEditorConfigured = false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
        BundleResourceProvider.configureCleanUp(context);
        this.addLogListener();
        if (EnvironmentUtils.IS_LINUX) {
            this.installPreferenceForwarder();
        }
    }

    public void stop(BundleContext context) throws Exception {
        m_plugin = null;
        super.stop(context);
    }

    public static DesignerPlugin getDefault() {
        return m_plugin;
    }

    public static IPreferenceStore getPreferences() {
        return DesignerPlugin.getDefault().getPreferenceStore();
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DesignerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = DesignerPlugin.getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = DesignerPlugin.getActivePage();
        return page != null ? page.getActiveEditor() : null;
    }

    public static Shell getShell() {
        if (DesignerPlugin.getActiveWorkbenchWindow() != null) {
            return DesignerPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    private static void addMouseWheelRedirector() {
        if (EnvironmentUtils.IS_WINDOWS) {
            final Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    Control cursorControl = Display.getDefault().getCursorControl();
                    if (cursorControl instanceof Scrollable && cursorControl != event.widget) {
                        event.doit = false;
                        if ((cursorControl.getStyle() & 0x200) != 0) {
                            OSSupport.get().scroll(cursorControl, event.count);
                        }
                    }
                }
            };
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    display.addFilter(37, listener);
                }
            });
        }
    }

    private static void setupEventFilters() {
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 262144) {
                    if (event.type == 1) {
                        m_ctrlPressed = true;
                    }
                    if (event.type == 2) {
                        m_ctrlPressed = false;
                    }
                    return;
                }
                if (event.keyCode == 131072) {
                    if (event.type == 1) {
                        m_shiftPressed = true;
                    }
                    if (event.type == 2) {
                        m_shiftPressed = false;
                    }
                    return;
                }
            }
        };
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                display.addFilter(3, listener);
                display.addFilter(4, listener);
                display.addFilter(1, listener);
                display.addFilter(2, listener);
                display.addFilter(31, listener);
            }
        });
    }

    public static boolean isCtrlPressed() {
        return m_ctrlPressed;
    }

    public static boolean isShiftPressed() {
        return m_shiftPressed;
    }

    public static void installSecurityManager() {
        System.setSecurityManager(new SecurityManager(){

            public void checkPermission(Permission perm) {
                if (this.isExitVM(perm)) {
                    StackTraceElement[] stackTrace;
                    StackTraceElement[] stackTraceElementArray = stackTrace = Thread.currentThread().getStackTrace();
                    int n = stackTrace.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement element = stackTraceElementArray[n2];
                        String className = element.getClassName();
                        String methodName = element.getMethodName();
                        if (!className.equals(this.getClass().getName())) {
                            if (className.equals("javax.swing.JFrame") && methodName.equals("setDefaultCloseOperation")) {
                                return;
                            }
                            if (className.startsWith("org.eclipse.wb.") || className.startsWith("com.google.gdt.eclipse.designer.") || className.startsWith("net.rim.ejde.designer.") || className.startsWith("java.awt.EventQueue")) {
                                if (methodName.startsWith("test_") && methodName.endsWith("_exit")) {
                                    return;
                                }
                                throw new SecurityException("Exit from within user-loaded code");
                            }
                        }
                        ++n2;
                    }
                }
            }

            private boolean isExitVM(Permission perm) {
                return perm instanceof RuntimePermission && StringUtils.startsWith((String)perm.getName(), (String)"exitVM");
            }
        });
    }

    public static void setDisplayExceptionOnConsole(boolean displayExceptionOnConsole) {
        m_displayExceptionOnConsole = displayExceptionOnConsole;
    }

    public static void log(IStatus status) {
        DesignerPlugin pluginInstance = DesignerPlugin.getDefault();
        if (pluginInstance != null) {
            pluginInstance.getLog().log(status);
        }
    }

    public static void log(String message) {
        DesignerPlugin.log((IStatus)new Status(1, PLUGIN_ID, 1, message, null));
    }

    public static void log(Throwable e) {
        String message;
        if (m_displayExceptionOnConsole) {
            e.printStackTrace();
        }
        if ((message = e.getMessage()) == null) {
            message = e.getClass().getName();
        }
        String versionString = ProductInfo.getProduct().getVersion().toString();
        String buildString = ProductInfo.getProduct().getBuild();
        DesignerPlugin.log("Designer [" + versionString + (versionString.endsWith(buildString) ? "" : "." + buildString) + "]: " + message, e);
    }

    public static void log(String message, Throwable e) {
        DesignerPlugin.log((IStatus)DesignerPlugin.createStatus(message, e));
    }

    public static Status createStatus(String message, Throwable e) {
        return new Status(4, PLUGIN_ID, 4, message, e){

            public boolean isMultiStatus() {
                return true;
            }
        };
    }

    private void addLogListener() {
        ILog log = this.getLog();
        log.addLogListener(new ILogListener(){

            public void logging(IStatus status, String plugin) {
                DesignerPlugin.this.setLastStatus(status);
            }
        });
    }

    private void setLastStatus(IStatus lastStatus) {
        this.m_lastStatus = lastStatus;
    }

    private IStatus getLastStatus0() {
        return this.m_lastStatus;
    }

    public static IStatus getLastStatus() {
        DesignerPlugin pluginInstance = DesignerPlugin.getDefault();
        if (pluginInstance != null) {
            return pluginInstance.getLastStatus0();
        }
        return null;
    }

    public static InputStream getFile(String path) {
        return m_resourceProvider.getFile(path);
    }

    public static Image getImage(String path) {
        return m_resourceProvider.getImage("icons/" + path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return m_resourceProvider.getImageDescriptor("icons/" + path);
    }

    private void installPreferenceForwarder() {
        new PreferenceToSystemForwarder(this.getPreferenceStore(), "common.linux.disableScreenshotWorkarounds", "__wbp.linux.disableScreenshotWorkarounds");
    }

    public static synchronized void configurePreEditor() {
        if (m_preEditorConfigured) {
            return;
        }
        m_preEditorConfigured = true;
        DesignerPlugin.setupEventFilters();
        DesignerPlugin.addMouseWheelRedirector();
    }
}

