/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.wb.core.editor.actions.assistant.ILayoutAssistantPage;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AnchorsActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.IActionImageProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementsSupport;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormLayoutEditPolicy;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutAssistantPage<C extends IControlInfo>
extends Composite
implements ILayoutAssistantPage {
    private final List<C> m_selection;
    private final IFormLayoutInfo<C> m_layout;
    private final PlacementsSupport m_placementsSupport;
    private final IActionImageProvider m_imageProvider = new IActionImageProvider(){

        public Image getActionImage(String imagePath) {
            return FormLayoutInfoImplAutomatic.getImage(imagePath);
        }
    };

    public LayoutAssistantPage(IFormLayoutInfo<C> layout, PlacementsSupport placementsSupport, Composite parent, Object selection) {
        super(parent, 0);
        this.m_layout = layout;
        this.m_placementsSupport = placementsSupport;
        this.m_selection = selection instanceof List ? (List<Object>)selection : Collections.singletonList((IControlInfo)selection);
        GridLayoutFactory.create((Composite)this);
        Group group = new Group((Composite)this, 0);
        GridDataFactory.create((Control)group).fill().grab();
        group.setText(ModelMessages.LayoutAssistantPage_anchorsGroup);
        GridLayoutFactory.create((Composite)group);
        ToolBarManager manager = new ToolBarManager();
        GridDataFactory.create((Control)manager.createControl((Composite)group)).fill().grab();
        this.fillAnchorsActions((IContributionManager)manager);
        manager.update(true);
        manager = new ToolBarManager();
        GridDataFactory.create((Control)manager.createControl((Composite)group)).fill().grab();
        this.fillComplexAnchorsActions((IContributionManager)manager);
        manager.update(true);
        group = new Group((Composite)this, 0);
        GridDataFactory.create((Control)group).fill().grab();
        group.setText(ModelMessages.LayoutAssistantPage_alignmentGroup);
        GridLayoutFactory.create((Composite)group);
        manager = new ToolBarManager();
        GridDataFactory.create((Control)manager.createControl((Composite)group)).fill().grab();
        this.fillAlignmentActions((IContributionManager)manager);
        manager.update(true);
    }

    public boolean isPageValid() {
        for (IControlInfo object : this.m_selection) {
            ObjectInfo parent = object.getParent();
            if (parent.getChildren().contains(object)) continue;
            return false;
        }
        return true;
    }

    public void updatePage() {
    }

    private void fillAnchorsActions(IContributionManager manager) {
        IControlInfo widget = this.m_selection.size() == 1 ? (IControlInfo)this.m_selection.get(0) : null;
        new AnchorsActionsSupport(this.m_placementsSupport, this.m_imageProvider).fillAnchorsActions(manager, (IAbstractComponentInfo)widget, false);
        new AnchorsActionsSupport(this.m_placementsSupport, this.m_imageProvider).fillAnchorsActions(manager, (IAbstractComponentInfo)widget, true);
    }

    private void fillAlignmentActions(IContributionManager manager) {
        ArrayList actions = Lists.newArrayList();
        new FormLayoutEditPolicy.FormLayoutAlignmentActionsSupport<C>(this.m_layout, this.m_placementsSupport).addAlignmentActions(GenericsUtils.cast(this.m_selection), actions);
        for (Object action : actions) {
            if (action instanceof IContributionItem) {
                manager.add((IContributionItem)action);
                continue;
            }
            if (!(action instanceof IAction)) continue;
            manager.add((IAction)action);
        }
    }

    private void fillComplexAnchorsActions(IContributionManager manager) {
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentTopLeft, "assistant/top_left.gif", 9));
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentTopRight, "assistant/top_right.gif", 12));
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentBottomLeft, "assistant/bottom_left.gif", 33));
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentBottomRight, "assistant/bottom_right.gif", 36));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentLeftRightTop, "assistant/top_left_right.gif", 13));
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentLeftRightBottom, "assistant/bottom_left_right.gif", 37));
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentTopBottomLeft, "assistant/top_bottom_left.gif", 41));
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentTopLBottomRight, "assistant/top_bottom_right.gif", 44));
        manager.add((IAction)new SetCornerAnchorsAction(this.m_selection, ModelMessages.LayoutAssistantPage_alignmentAll, "assistant/top_bottom_left_right.gif", 45));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SetCornerAnchorsAction
    extends ObjectInfoAction {
        private final int m_alignment;
        private final List<C> m_widgets;

        private SetCornerAnchorsAction(List<C> selection, String text, String imageName, int alignment) {
            super(LayoutAssistantPage.this.m_layout.getUnderlyingModel(), text, LayoutAssistantPage.this.m_imageProvider.getActionImage(imageName));
            this.m_widgets = selection;
            this.m_alignment = alignment;
        }

        protected void runEx() throws Exception {
            for (IControlInfo widget : this.m_widgets) {
                if ((this.m_alignment & 1) != 0 && (this.m_alignment & 4) != 0) {
                    LayoutAssistantPage.this.m_placementsSupport.setResizeable((IAbstractComponentInfo)widget, true);
                } else {
                    this.checkAlignment(widget, 1);
                    this.checkAlignment(widget, 4);
                }
                if ((this.m_alignment & 8) != 0 && (this.m_alignment & 0x20) != 0) {
                    LayoutAssistantPage.this.m_placementsSupport.setResizeable((IAbstractComponentInfo)widget, false);
                    continue;
                }
                this.checkAlignment(widget, 8);
                this.checkAlignment(widget, 32);
            }
        }

        private void checkAlignment(C widget, int alignment) throws Exception {
            if ((this.m_alignment & alignment) != 0) {
                LayoutAssistantPage.this.m_placementsSupport.setAlignment(widget, alignment);
            }
        }
    }
}

