/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.selection;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.core.gef.header.AbstractHeaderSelectionEditPolicy;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.ILocator;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.selection.ResizeHintFigure;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;

abstract class DimensionSelectionEditPolicy<T extends FormDimensionInfo>
extends AbstractHeaderSelectionEditPolicy {
    protected static final String REQ_RESIZE = "resize";
    private Figure m_lineFeedback;
    private ResizeHintFigure m_feedback;
    private ChangeBoundsRequest m_lastResizeRequest;
    protected Command m_resizeCommand;

    public DimensionSelectionEditPolicy(LayoutEditPolicy mainPolicy) {
        super(mainPolicy);
    }

    protected List<Handle> createSelectionHandles() {
        List handles = Lists.newArrayList();
        MoveHandle moveHandle = new MoveHandle(this.getHost(), (ILocator)new HeaderMoveHandleLocator());
        moveHandle.setForeground(IColorConstants.red);
        handles.add(moveHandle);
        return handles;
    }

    protected List<Handle> createStaticHandles() {
        List handles = Lists.newArrayList();
        DimensionHeaderEditPart<T> headerEditPart = this.getHostHeader();
        if (!((FormDimensionInfo)headerEditPart.getDimension()).isGap()) {
            handles.add(this.createResizeHandle());
        }
        return handles;
    }

    protected abstract Handle createResizeHandle();

    private DimensionHeaderEditPart<T> getHostHeader() {
        return (DimensionHeaderEditPart)this.getHost();
    }

    protected final FormLayoutInfo getLayout() {
        return this.getHostHeader().getLayout();
    }

    protected final T getDimension() {
        return this.getHostHeader().getDimension();
    }

    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == REQ_RESIZE;
    }

    public Command getCommand(Request request) {
        if (!this.getLayout().canChangeDimensions()) {
            return null;
        }
        return new Command(){

            public void execute() throws Exception {
                DimensionSelectionEditPolicy.this.getHost().getViewer().getEditDomain().executeCommand(DimensionSelectionEditPolicy.this.m_resizeCommand);
            }
        };
    }

    public void showSourceFeedback(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        this.m_resizeCommand = null;
        if (this.m_lineFeedback == null) {
            this.m_lineFeedback = new Figure();
            LineBorder border = new LineBorder(IColorConstants.red, 2);
            this.m_lineFeedback.setBorder((Border)border);
            this.addFeedback(this.m_lineFeedback);
        }
        Figure hostFigure = this.getHostFigure();
        Rectangle bounds = changeBoundsRequest.getTransformedRectangle(hostFigure.getBounds());
        FigureUtils.translateFigureToAbsolute((Figure)hostFigure, (Translatable)bounds);
        this.m_lineFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Feedback Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new ResizeHintFigure();
            feedbackLayer.add((Figure)this.m_feedback);
        }
        Point mouseLocation = changeBoundsRequest.getLocation().getCopy();
        Point feedbackLocation = this.getTextFeedbackLocation(mouseLocation);
        FigureUtils.translateAbsoluteToFigure((Figure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_lastResizeRequest = changeBoundsRequest;
        this.updateFeedbackText((Request)changeBoundsRequest);
        String hintSize = ((FormDimensionInfo)this.getDimension()).getSize().getComponentSize() == null ? "minimum" : "constant";
        this.m_feedback.setSizeHint(hintSize);
    }

    private void updateFeedbackText(Request request) {
        this.m_feedback.setText(this.getTextFeedbackText(this.m_lastResizeRequest, request.isControlKeyPressed()));
    }

    public void eraseSourceFeedback(Request request) {
        this.removeFeedback(this.m_lineFeedback);
        this.m_lineFeedback = null;
        this.m_feedback.getParent().remove((Figure)this.m_feedback);
        this.m_feedback = null;
    }

    public void performRequest(Request request) {
        KeyRequest keyRequest;
        if (this.m_feedback != null && request instanceof KeyRequest && (keyRequest = (KeyRequest)request).getKeyCode() == 262144) {
            this.m_feedback.setShowSizeHint(!keyRequest.isPressed());
            this.updateFeedbackText(request);
        }
    }

    protected abstract Point getTextFeedbackLocation(Point var1);

    protected abstract String getTextFeedbackText(ChangeBoundsRequest var1, boolean var2);

    private class HeaderMoveHandleLocator
    implements ILocator {
        private HeaderMoveHandleLocator() {
        }

        public void relocate(Figure target) {
            Figure reference = DimensionSelectionEditPolicy.this.getHostFigure();
            Rectangle bounds = reference.getBounds().getCopy();
            FigureUtils.translateFigureToFigure((Figure)reference, (Figure)target, (Translatable)bounds);
            target.setBounds(bounds);
        }
    }
}

