/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.util.surround.ISurroundProcessor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutSurroundSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;

public final class FormLayoutSurroundProcessor
implements ISurroundProcessor<ContainerInfo, ComponentInfo> {
    public static final Object INSTANCE = new FormLayoutSurroundProcessor();

    private FormLayoutSurroundProcessor() {
    }

    public boolean filter(ContainerInfo sourceContainer, ContainerInfo targetContainer) throws Exception {
        String targetClassName = targetContainer.getDescription().getComponentClass().getName();
        boolean isJPanel = targetClassName.equals("javax.swing.JPanel");
        return sourceContainer.hasLayout() && sourceContainer.getLayout() instanceof FormLayoutInfo && isJPanel;
    }

    public void move(ContainerInfo sourceContainer, ContainerInfo targetContainer, List<ComponentInfo> components) throws Exception {
        FormLayoutInfo targetLayout = (FormLayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)targetContainer.getEditor(), (String)"com.jgoodies.forms.layout.FormLayout", (CreationSupport)new ConstructorCreationSupport());
        targetContainer.setLayout((LayoutInfo)targetLayout);
        Rectangle targetBounds = (Rectangle)targetContainer.getArbitraryValue((Object)"SurroundSupport_CELLS");
        FormLayoutInfo sourceLayout = (FormLayoutInfo)sourceContainer.getLayout();
        List targetColumns = Lists.newArrayList();
        int columnIndex = targetBounds.x;
        while (columnIndex < targetBounds.right()) {
            FormColumnInfo sourceColumn = sourceLayout.getColumns().get(columnIndex - 1);
            targetColumns.add(sourceColumn.copy());
            ++columnIndex;
        }
        targetLayout.setColumns(targetColumns);
        List targetRows = Lists.newArrayList();
        int rowIndex = targetBounds.y;
        while (rowIndex < targetBounds.bottom()) {
            FormRowInfo sourceRow = sourceLayout.getRows().get(rowIndex - 1);
            targetRows.add(sourceRow.copy());
            ++rowIndex;
        }
        targetLayout.setRows(targetRows);
        Point locationOffset = targetBounds.getLocation().getNegated();
        for (ComponentInfo component : components) {
            CellConstraintsSupport oldConstraints = FormLayoutInfo.getConstraints(component);
            Rectangle cells = FormLayoutSurroundSupport.getCells(component);
            cells = cells.getTranslated(locationOffset);
            targetLayout.command_ADD(component, 1 + cells.x, false, 1 + cells.y, false);
            CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
            constraints.width = oldConstraints.width;
            constraints.height = oldConstraints.height;
            constraints.alignH = oldConstraints.alignH;
            constraints.alignV = oldConstraints.alignV;
            constraints.write();
        }
    }
}

