/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.xml.ui;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.core.editor.DesignerState;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.ParseState;
import org.eclipse.wb.internal.core.databinding.ui.EditComposite;
import org.eclipse.wb.internal.core.databinding.ui.EditSelection;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.xml.Messages;
import org.eclipse.wb.internal.core.databinding.xml.parser.DatabindingRootProcessor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.xml.editor.IXmlEditorPage;
import org.eclipse.wb.internal.core.xml.editor.UndoManager;
import org.eclipse.wb.internal.core.xml.editor.XmlEditorPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindingXmlPage
extends XmlEditorPage {
    private Composite m_composite;
    private EditComposite m_editComposite;
    private CLabel m_errorLabel;
    private IDatabindingsProvider m_databindingsProvider;

    public static void addPage(List<IXmlEditorPage> pages) {
        for (IXmlEditorPage page : pages) {
            if (!(page instanceof BindingXmlPage)) continue;
            return;
        }
        pages.add((IXmlEditorPage)new BindingXmlPage());
    }

    public void dispose() {
        DatabindingRootProcessor.STATES.remove(this.m_editor.getDocument());
    }

    public void setActive(boolean active) {
        UndoManager undoManager = this.m_editor.getDesignPage().getUndoManager();
        if (active) {
            undoManager.activate();
            this.handleUpdatePage();
        } else {
            undoManager.deactivate();
        }
    }

    private void handleUpdatePage() {
        boolean isNew;
        if (this.m_editor.getDesignPage().getDesignerState() != DesignerState.Successful) {
            if (this.m_editComposite != null) {
                this.m_editComposite.dispose();
                this.m_editComposite = null;
            }
            if (this.m_errorLabel != null) {
                this.m_errorLabel.dispose();
            }
            this.m_errorLabel = new CLabel(this.m_composite, 0);
            this.m_errorLabel.setText(Messages.BindingXmlPage_errorMessage);
            this.m_errorLabel.setImage(Activator.getImage((String)"errors.gif"));
            GridDataFactory.create((Control)this.m_errorLabel).fillH().grabH();
            this.m_databindingsProvider = null;
            this.m_composite.layout();
            return;
        }
        EditSelection selection = this.m_editComposite == null ? null : this.m_editComposite.getEditSelection();
        ParseState state = DatabindingRootProcessor.STATES.get(this.m_editor.getDocument());
        Assert.isNotNull((Object)state);
        boolean bl = isNew = this.m_databindingsProvider != state.databindingsProvider;
        if (isNew) {
            if (this.m_editComposite != null) {
                this.m_editComposite.dispose();
            }
            if (this.m_errorLabel != null) {
                this.m_errorLabel.dispose();
                this.m_errorLabel = null;
            }
            this.m_databindingsProvider = state.databindingsProvider;
            IDialogSettings settings = UiUtils.getSettings((IDialogSettings)state.plugin.getDialogSettings(), (String)this.m_databindingsProvider.getClass().getName());
            this.m_editComposite = new EditComposite(this.m_composite, 0, state.plugin, this.m_databindingsProvider, settings);
            GridDataFactory.create((Control)this.m_editComposite).fill().grab();
            this.m_composite.layout();
        }
        this.m_editComposite.setInput(!isNew, selection);
    }

    public Control createControl(Composite parent) {
        this.m_composite = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)this.m_composite).noMargins().noSpacing();
        return this.m_composite;
    }

    public Control getControl() {
        return this.m_composite;
    }

    public String getName() {
        return Messages.BindingXmlPage_name;
    }

    public Image getImage() {
        return Activator.getImage((String)"paperclip.png");
    }
}

