/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.policies;

import java.util.List;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.events.IEditPolicyListener;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.internal.draw2d.events.EventTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditPolicy {
    public static final String SELECTION_ROLE = "Selection Feedback";
    public static final String LAYOUT_ROLE = "LayoutEditPolicy";
    private EditPart m_host;
    private boolean m_isActive;
    private EventTable m_eventTable;

    public void activate() {
        this.m_isActive = true;
        this.fireActivate();
    }

    public void deactivate() {
        this.fireDeactivate();
        this.m_isActive = false;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public void dispose() {
    }

    public EditPart getHost() {
        return this.m_host;
    }

    public void setHost(EditPart host) {
        this.m_host = host;
    }

    public Command getCommand(Request request) {
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        return null;
    }

    public boolean understandsRequest(Request request) {
        return false;
    }

    public void performRequest(Request request) {
    }

    public void showSourceFeedback(Request request) {
    }

    public void eraseSourceFeedback(Request request) {
    }

    public void showTargetFeedback(Request request) {
    }

    public void eraseTargetFeedback(Request request) {
    }

    public void addEditPolicyListener(IEditPolicyListener listener) {
        this.getEnsureEventTable().addListener(IEditPolicyListener.class, listener);
    }

    public void removeEditPolicyListener(IEditPolicyListener listener) {
        this.getEnsureEventTable().removeListener(IEditPolicyListener.class, listener);
    }

    public <L> List<L> getListeners(Class<L> listenerClass) {
        return this.m_eventTable == null ? null : this.m_eventTable.getListeners(listenerClass);
    }

    protected EventTable getEnsureEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventTable();
        }
        return this.m_eventTable;
    }

    private void fireActivate() {
        List<IEditPolicyListener> listeners = this.getListeners(IEditPolicyListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            for (IEditPolicyListener listener : listeners) {
                listener.activatePolicy(this);
            }
        }
    }

    private void fireDeactivate() {
        List<IEditPolicyListener> listeners = this.getListeners(IEditPolicyListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            for (IEditPolicyListener listener : listeners) {
                listener.deactivatePolicy(this);
            }
        }
    }

    protected final Object getHostModel() {
        return this.getHost().getModel();
    }
}

