/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wb.core.controls.PageBook;
import org.eclipse.wb.core.editor.DesignerState;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.EditorActivatedListener;
import org.eclipse.wb.core.model.broadcast.EditorActivatedRequest;
import org.eclipse.wb.gef.core.ICommandExceptionHandler;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.DesignComposite;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.structure.PartListenerAdapter;
import org.eclipse.wb.internal.core.utils.Debug;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.Activator;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.editor.AbstractXmlEditor;
import org.eclipse.wb.internal.core.xml.editor.IRefreshStrategy;
import org.eclipse.wb.internal.core.xml.editor.UndoManager;
import org.eclipse.wb.internal.core.xml.editor.XmlDesignComposite;
import org.eclipse.wb.internal.core.xml.editor.XmlEditorPage;
import org.eclipse.wb.internal.core.xml.editor.XmlExceptionComposite;
import org.eclipse.wb.internal.core.xml.editor.XmlWarningComposite;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.utils.GlobalStateXml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlDesignPage
extends XmlEditorPage {
    protected IFile m_file;
    protected IDocument m_document;
    protected Composite m_composite;
    private PageBook m_pageBook;
    private XmlDesignComposite m_designComposite;
    private final Map<Class<?>, Composite> m_errorCompositesMap = Maps.newHashMap();
    private UndoManager m_undoManager;
    protected XmlObjectInfo m_rootObject;
    private DesignerState m_designerState = DesignerState.Undefined;
    private boolean m_forceDocumentListener;
    private final IPartListener m_partListener = new PartListenerAdapter(){

        public void partActivated(IWorkbenchPart part) {
            if (part == XmlDesignPage.this.m_editor) {
                ExecutionUtils.runAsync((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        GlobalStateXml.activate((this).XmlDesignPage.this.m_rootObject);
                        if ((this).XmlDesignPage.this.m_active) {
                            XmlDesignPage.this.checkDependenciesOnDesignPageActivation();
                        }
                    }
                });
            }
        }
    };

    @Override
    public void initialize(AbstractXmlEditor editor) {
        super.initialize(editor);
        this.m_file = ((IFileEditorInput)editor.getEditorInput()).getFile();
        this.m_document = editor.getDocument();
        this.m_undoManager = new UndoManager(this, this.m_document);
        this.m_editor.getEditorSite().getPage().addPartListener(this.m_partListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_undoManager.deactivate();
        this.m_editor.getEditorSite().getPage().removePartListener(this.m_partListener);
        this.disposeAll(true);
    }

    private void disposeAll(final boolean force) {
        if (!this.m_composite.isDisposed()) {
            this.dispose_beforePresentation();
            this.m_designComposite.disposeDesign();
        }
        if (this.m_rootObject != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    XmlDesignPage.this.m_rootObject.refresh_dispose();
                    XmlDesignPage.this.m_rootObject.getBroadcastObject().dispose();
                    XmlDesignPage.this.disposeContext(force);
                    GlobalStateXml.deactivate(XmlDesignPage.this.m_rootObject);
                }
            });
            this.m_rootObject = null;
        }
    }

    private void dispose_beforePresentation() {
        if (this.m_rootObject != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    XmlDesignPage.this.m_rootObject.getBroadcastObject().dispose_beforePresentation();
                }
            });
        }
    }

    protected void disposeContext(boolean force) {
        if (this.m_rootObject != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    XmlDesignPage.this.m_rootObject.getContext().dispose();
                }
            });
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.m_undoManager.activate();
            this.m_designComposite.onActivate();
            this.checkDependenciesOnDesignPageActivation();
        } else {
            if (!this.m_forceDocumentListener) {
                this.m_undoManager.deactivate();
            }
            this.m_designComposite.onDeActivate();
        }
    }

    private void checkDependenciesOnDesignPageActivation() {
        if (this.m_rootObject != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    EditorActivatedRequest request = new EditorActivatedRequest();
                    ((EditorActivatedListener)XmlDesignPage.this.m_rootObject.getBroadcast(EditorActivatedListener.class)).invoke(request);
                    if (request.isReparseRequested()) {
                        XmlDesignPage.this.refreshGEF();
                    } else if (request.isRefreshRequested()) {
                        XmlDesignPage.this.m_rootObject.refresh();
                    }
                }
            });
        }
    }

    public final DesignComposite getDesignComposite() {
        return this.m_designComposite;
    }

    public DesignerState getDesignerState() {
        return this.m_designerState;
    }

    public UndoManager getUndoManager() {
        return this.m_undoManager;
    }

    public void forceDocumentListener() {
        this.m_forceDocumentListener = true;
    }

    public void setRefreshStrategy(IRefreshStrategy refreshStrategy) {
        this.m_undoManager.setRefreshStrategy(refreshStrategy);
    }

    @Override
    public Control createControl(Composite parent) {
        this.m_composite = new Composite(parent, 0);
        this.m_composite.setLayout((Layout)new FillLayout());
        this.m_pageBook = new PageBook(this.m_composite, 0);
        ICommandExceptionHandler exceptionHandler = new ICommandExceptionHandler(){

            public void handleException(Throwable exception) {
                XmlDesignPage.this.handleDesignException(exception);
            }
        };
        this.m_designComposite = this.createDesignComposite((Composite)this.m_pageBook, exceptionHandler);
        this.m_pageBook.showPage((Control)this.m_designComposite);
        return this.m_composite;
    }

    protected XmlDesignComposite createDesignComposite(Composite parent, ICommandExceptionHandler exceptionHandler) {
        return new XmlDesignComposite(parent, 0, (IEditorPart)this.m_editor, exceptionHandler);
    }

    @Override
    public Control getControl() {
        return this.m_composite;
    }

    private <T extends Composite> T getErrorComposite(Class<T> compositeClass) throws Exception {
        Composite composite = this.m_errorCompositesMap.get(compositeClass);
        if (composite == null) {
            Constructor<T> constructor = compositeClass.getConstructor(Composite.class, Integer.TYPE);
            composite = (Composite)constructor.newInstance(this.m_pageBook, 0);
            this.m_errorCompositesMap.put(compositeClass, composite);
        }
        return (T)composite;
    }

    private void handleDesignException(Throwable e) {
        Image screenshot;
        try {
            screenshot = DesignerExceptionUtils.makeScreenshot();
        }
        catch (Throwable throwable) {
            screenshot = null;
        }
        this.disposeAll(true);
        if (EnvironmentUtils.isTestingTime()) {
            e.printStackTrace();
        }
        this.showExceptionOnDesignPane(e, screenshot);
    }

    private void setEnabled(boolean enabled) {
        this.m_composite.setRedraw(enabled);
    }

    @Override
    public String getName() {
        return Messages.XmlDesignPage_name;
    }

    @Override
    public Image getImage() {
        return Activator.getImage("editor_page_design.png");
    }

    protected boolean shouldShowProgress() {
        return false;
    }

    protected abstract XmlObjectInfo parse() throws Exception;

    public void refreshGEF() {
        this.disposeContext(true);
        this.updateGEF();
    }

    void updateGEF() {
        this.m_undoManager.refreshDesignerEditor();
    }

    boolean internal_refreshGEF() {
        if (this.m_forceDocumentListener) {
            this.m_designComposite.setEnabled(false);
            try {
                this.parse();
            }
            catch (Throwable throwable) {
                return false;
            }
            this.m_designComposite.setEnabled(true);
        }
        this.setEnabled(false);
        try {
            this.m_designerState = DesignerState.Parsing;
            this.disposeAll(false);
            if (this.shouldShowProgress()) {
                this.internal_refreshGEF_withProgress();
            } else {
                this.internal_refreshGEF((IProgressMonitor)new NullProgressMonitor());
            }
            this.m_pageBook.showPage((Control)this.m_designComposite);
            this.m_designerState = DesignerState.Successful;
            return true;
        }
        catch (Throwable e) {
            this.showExceptionOnDesignPane(e, null);
            return false;
        }
        finally {
            this.setEnabled(true);
        }
    }

    private void internal_refreshGEF_withProgress() throws Exception {
        final Display display = Display.getCurrent();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) {
                block5: {
                    monitor.beginTask(Messages.XmlDesignPage_progressTitle, 6);
                    try {
                        try {
                            DesignPageSite.setProgressMonitor((IProgressMonitor)monitor);
                            display.syncExec(new Runnable(){

                                public void run() {
                                    try {
                                        XmlDesignPage.this.internal_refreshGEF(monitor);
                                    }
                                    catch (Throwable e) {
                                        ReflectionUtils.propagate((Throwable)e);
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            ReflectionUtils.propagate((Throwable)e);
                            DesignPageSite.setProgressMonitor(null);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        DesignPageSite.setProgressMonitor(null);
                        throw throwable;
                    }
                    DesignPageSite.setProgressMonitor(null);
                }
                monitor.subTask(null);
                ExecutionUtils.waitEventLoop((int)100);
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(DesignerPlugin.getShell()).run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.propagate((Throwable)e.getCause());
        }
        catch (Throwable e) {
            ReflectionUtils.propagate((Throwable)e);
        }
    }

    private void internal_refreshGEF(IProgressMonitor monitor) throws Exception {
        monitor.subTask(Messages.XmlDesignPage_progressInitialing);
        monitor.worked(1);
        long start = System.currentTimeMillis();
        monitor.subTask(Messages.XmlDesignPage_progressParsing);
        Debug.print((Object)"Parsing...");
        this.m_rootObject = this.parse();
        monitor.worked(1);
        Debug.println((Object)("done: " + (System.currentTimeMillis() - start)));
        start = System.currentTimeMillis();
        monitor.subTask(Messages.XmlDesignPage_progressRefreshing);
        this.m_rootObject.refresh();
        monitor.worked(1);
        Debug.println((Object)("refresh: " + (System.currentTimeMillis() - start)));
        this.installDesignPageSite();
        this.m_designComposite.refresh(this.m_rootObject, monitor);
        this.m_undoManager.setRoot(this.m_rootObject);
    }

    private void installDesignPageSite() {
        DesignPageSite designPageSite = new DesignPageSite(){

            public void showSourcePosition(int position) {
                XmlDesignPage.this.m_editor.showSourcePosition(position);
            }

            public void openSourcePosition(int position) {
                XmlDesignPage.this.m_editor.showSourcePosition(position);
                XmlDesignPage.this.m_editor.showSource();
            }

            public void handleException(Throwable e) {
                XmlDesignPage.this.handleDesignException(e);
            }

            public void reparse() {
                XmlDesignPage.this.refreshGEF();
            }
        };
        DesignPageSite.Helper.setSite((ObjectInfo)this.m_rootObject, (IDesignPageSite)designPageSite);
    }

    private void showExceptionOnDesignPane(Throwable e, Image screenshot) {
        this.m_designerState = DesignerState.Error;
        this.disposeContext(true);
        try {
            e = DesignerExceptionUtils.rewriteException((Throwable)e);
            if (DesignerExceptionUtils.isWarning((Throwable)e)) {
                XmlWarningComposite composite = this.getErrorComposite(XmlWarningComposite.class);
                composite.setException(e);
                this.m_pageBook.showPage((Control)composite);
            } else {
                DesignerPlugin.log((Throwable)e);
                XmlExceptionComposite composite = this.getErrorComposite(XmlExceptionComposite.class);
                composite.setException(e, screenshot, this.m_file, this.m_document);
                this.m_pageBook.showPage((Control)composite);
            }
        }
        catch (Throwable throwable) {}
    }
}

