/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.HasSourcePosition;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.hierarchy.ComponentClassProperty;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.IXMLObjectInitializationParticipator;
import org.eclipse.wb.internal.core.xml.model.XmlObjectPresentation;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAddProperties;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectSetObjectAfter;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.xml.model.property.event.EventsProperty;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectInfo
extends ObjectInfo
implements HasSourcePosition {
    public static final String FLAG_MANUAL_COMPONENT = "manuallyCreatedComponent";
    private final EditorContext m_context;
    private final ComponentDescription m_description;
    private CreationSupport m_creationSupport;
    private Object m_object;
    private List<GenericProperty> m_descriptionBasedProperties;
    private final EventsProperty m_eventsProperty;
    private final ComponentClassProperty m_componentClassProperty;
    private boolean m_objectReadySent = false;
    private boolean m_initialized;
    private final Map<String, Object> m_attributeValues = Maps.newHashMap();

    public XmlObjectInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        this.m_context = context;
        this.m_description = description;
        this.m_creationSupport = creationSupport;
        this.setBroadcastSupport(context.getBroadcastSupport());
        this.m_creationSupport.setObject(this);
        Class<?> componentClass = description.getComponentClass();
        if (componentClass == null) {
            this.m_componentClassProperty = null;
            this.m_eventsProperty = null;
        } else {
            IJavaProject javaProject = context.getJavaProject();
            this.m_componentClassProperty = new ComponentClassProperty(javaProject, componentClass);
            this.m_eventsProperty = new EventsProperty(this);
        }
    }

    public IObjectPresentation getPresentation() {
        return new XmlObjectPresentation(this);
    }

    public EditorContext getContext() {
        return this.m_context;
    }

    public final ComponentDescription getDescription() {
        return this.m_description;
    }

    public final CreationSupport getCreationSupport() {
        return this.m_creationSupport;
    }

    public final void setCreationSupport(CreationSupport creationSupport) throws Exception {
        this.m_creationSupport = creationSupport;
        this.m_creationSupport.setObject(this);
    }

    public final XmlObjectInfo getParentXML() {
        return (XmlObjectInfo)this.getParent();
    }

    public final XmlObjectInfo getRootXML() {
        return (XmlObjectInfo)this.getRoot();
    }

    public final List<XmlObjectInfo> getChildrenXML() {
        return this.getChildren(XmlObjectInfo.class);
    }

    public int getSourcePosition() {
        return this.getCreationSupport().getElement().getOffset();
    }

    protected List<Property> getPropertyList() throws Exception {
        List properties = Lists.newArrayList();
        if (this.m_descriptionBasedProperties == null) {
            this.m_descriptionBasedProperties = Lists.newArrayList();
            for (GenericPropertyDescription description : this.getDescription().getProperties()) {
                GenericPropertyImpl property = new GenericPropertyImpl(this, description);
                this.m_descriptionBasedProperties.add(property);
            }
        }
        properties.addAll(this.m_descriptionBasedProperties);
        if (this.m_componentClassProperty != null) {
            properties.add(this.m_componentClassProperty);
        }
        if (PropertyUtils.getChildren((Property)this.m_eventsProperty).length != 0) {
            properties.add(this.m_eventsProperty);
        }
        ((ObjectInfoAddProperties)this.getBroadcast(ObjectInfoAddProperties.class)).invoke((ObjectInfo)this, properties);
        ((XmlObjectAddProperties)this.getBroadcast(XmlObjectAddProperties.class)).invoke(this, properties);
        return properties;
    }

    protected void saveEdit() throws Exception {
        this.m_context.commit();
    }

    protected void onHierarchyDispose() throws Exception {
        if (this.isRoot()) {
            this.m_context.dispose();
        }
    }

    public final Object getObject() {
        return this.m_object;
    }

    public final void setObject(Object object) throws Exception {
        this.m_object = object;
        if (!this.isObjectReadySent()) {
            this.setObjectReadySent(true);
            this.m_description.visit(this, 1);
        }
        if (!this.m_initialized) {
            this.initialize();
        }
        ((XmlObjectSetObjectAfter)this.getBroadcast(XmlObjectSetObjectAfter.class)).invoke(this, this.m_object);
    }

    public final XmlObjectInfo getChildByObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o == this.m_object) {
            return this;
        }
        for (ObjectInfo child : this.getChildren()) {
            XmlObjectInfo xmlChild;
            XmlObjectInfo result;
            if (!(child instanceof XmlObjectInfo) || (result = (xmlChild = (XmlObjectInfo)child).getChildByObject(o)) == null) continue;
            return result;
        }
        return null;
    }

    protected void initialize() throws Exception {
        this.m_initialized = true;
        this.createExposedChildren();
        List participators = ExternalFactoriesHelper.getElementsInstances(IXMLObjectInitializationParticipator.class, (String)"org.eclipse.wb.core.xml.initializationParticipators", (String)"participator");
        for (IXMLObjectInitializationParticipator participator : participators) {
            participator.process(this);
        }
    }

    protected void createExposedChildren() throws Exception {
    }

    public final void registerAttributeValue(String attribute, Object value) {
        this.m_attributeValues.put(attribute, value);
    }

    public final Object getAttributeValue(String attribute) {
        if (this.m_attributeValues.containsKey(attribute)) {
            return this.m_attributeValues.get(attribute);
        }
        return Property.UNKNOWN_VALUE;
    }

    public final DocumentElement getElement() {
        return this.getCreationSupport().getElement();
    }

    public String getAttribute(String name) {
        return this.getElement().getAttribute(name);
    }

    public void setAttribute(String name, String value) {
        this.getElement().setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getElement().setAttribute(name, null);
    }

    public void refresh_dispose() throws Exception {
        this.m_object = null;
        this.m_attributeValues.clear();
        this.setObjectReadySent(false);
        super.refresh_dispose();
    }

    protected void refresh_afterCreate() throws Exception {
        super.refresh_afterCreate();
        XmlObjectUtils.executeScriptParameter(this, "refresh_afterCreate");
    }

    public String toString() {
        return this.getCreationSupport().toString();
    }

    public boolean canDelete() {
        return this.m_creationSupport.canDelete();
    }

    public void delete() throws Exception {
        final ObjectInfo parent = this.getParent();
        ObjectInfo hierarchyObject = parent != null ? parent : this;
        ExecutionUtils.run((ObjectInfo)hierarchyObject, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                XmlObjectInfo.this.putArbitraryValue("we are in process of deleting", Boolean.TRUE);
                try {
                    ((ObjectInfoDelete)XmlObjectInfo.this.getBroadcast(ObjectInfoDelete.class)).before(parent, (ObjectInfo)XmlObjectInfo.this);
                    XmlObjectInfo.this.m_creationSupport.delete();
                    ((ObjectInfoDelete)XmlObjectInfo.this.getBroadcast(ObjectInfoDelete.class)).after(parent, (ObjectInfo)XmlObjectInfo.this);
                }
                finally {
                    XmlObjectInfo.this.removeArbitraryValue("we are in process of deleting");
                }
            }
        });
    }

    public final void setObjectReadySent(boolean value) {
        this.m_objectReadySent = value;
    }

    public final boolean isObjectReadySent() {
        return this.m_objectReadySent;
    }
}

